<?php
declare(strict_types=1);

namespace App\Controller;

use Cake\Http\Response;

class ClinicServicesController extends AppController
{
    public function initialize(): void
    {
        parent::initialize();
        $this->loadComponent('Authentication.Authentication', ['requireIdentity' => true]);
        $this->ClinicServices = $this->fetchTable('ClinicServices');
    }

    /** Returns Select2-friendly list scoped to current clinic. */
    public function search(): Response
    {
        $this->request->allowMethod(['get']);
        // Use your existing helper to scope to current clinic
        $clinicId = method_exists($this, 'currentClinicId') ? (int)$this->currentClinicId() : (int)$this->request->getSession()->read('Current.clinic_id');

        $q = trim((string)$this->request->getQuery('q', ''));
        $rows = $this->ClinicServices->find()
            ->where(['clinic_id' => $clinicId, 'active' => 1])
            ->orderAsc('name');

        if ($q !== '') {
            $rows->where([
                'OR' => [
                    'name LIKE' => "%$q%",
                    'code LIKE' => "%$q%"
                ]
            ]);
        }

        $out = [];
        foreach ($rows as $r) {
            $price = is_numeric($r->price_cents) ? number_format($r->price_cents / 100, 2) : null;
            $label = $r->name;
            if ($r->duration_minutes) $label .= " ({$r->duration_minutes}m)";
            if ($price !== null)      $label .= " • AU\${$price}";
            $out[] = ['id' => (int)$r->id, 'text' => $label];
        }

        return $this->response->withType('json')->withStringBody(json_encode(['results' => $out]));
    }
}
