<?php
declare(strict_types=1);

namespace App\Controller;

class SettingsController extends AppController
{
    private \Cake\ORM\Table $RoleFeatureSettings;

    public function initialize(): void
    {
        parent::initialize();
        $this->RoleFeatureSettings = $this->fetchTable('RoleFeatureSettings');
    }

    public function index()
    {
        $identity = $this->request->getAttribute('identity');
        $role     = strtolower((string)($identity->get('role') ?? 'clinician'));
        $isAdmin  = ($role === 'admin');

        $Features     = $this->fetchTable('Features');
        $RoleSettings = $this->RoleFeatureSettings;

        $featuresAll = $Features->find('all')->orderByAsc('label')->all();

        $featureKeys = [];
        foreach ($featuresAll as $f) {
            $featureKeys[$f->key] = true;
        }

        if ($this->request->is(['post','put','patch'])) {
            $payload = (array)$this->request->getData('features', []);
            $ok = true;

            $filter = function(array $map) use ($featureKeys): array {
                return array_intersect_key($map, $featureKeys);
            };

            if (isset($payload['admin'])) {
                $ok = $ok && $RoleSettings->saveVisibilityForRole('admin', $filter((array)$payload['admin']));
            }
            if (isset($payload['clinician'])) {
                $ok = $ok && $RoleSettings->saveVisibilityForRole('clinician', $filter((array)$payload['clinician']));
            }

            $this->Flash->success($ok ? 'Saved.' : 'Save failed.');
            return $this->redirect(['action' => 'index']);
        }

        $mapAdmin     = $RoleSettings->getVisibleMapForRole('admin');
        $mapClinician = $RoleSettings->getVisibleMapForRole('clinician');

        $this->set(compact('featuresAll','mapAdmin','mapClinician','isAdmin'));
    }
}
