<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;
use Authentication\PasswordHasher\DefaultPasswordHasher;


class Login extends Entity

{
    protected array $_accessible = [
        'first_name'   => true,
        'last_name'    => true,
        'email'        => true,
        'password'     => true,
        'terms_agreed' => true,
        'created'      => true,
        'date_of_birth'     => true,
        'mobile_phone'     => true,
        'modified'     => true,
        'role'         => true,
        'participants' => true,
        'reset_token' => true,
        'reset_token_expires' => true,
        '*' => true,
        'id' => false,
        'specializations' => true,
        'emergency_name'  => true,
        'emergency_email' => true,
        'emergency_phone' => true,
    ];



    protected array $_hidden = ['password'];

    /**
     * Password mutator. Uses PHP's password_hash and avoids double-hashing.
     */
    protected function _setPassword(?string $password): ?string
    {
        if ($password === null || $password === '') {
            return $password;
        }

        $info = password_get_info($password);
        if (!empty($info['algo'])) {
            return $password;
        }

        return (new DefaultPasswordHasher())->hash($password);
    }
}
