<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Participant Entity
 *
 * @property int $id
 * @property string $first_name
 * @property string $middle_name
 * @property string|null $last_name
 *@property string|null preferred_name
 * @property string $email
 * @property string|null $phone
 * @property string|null $emergency_contact_name
 * @property string|null $emergency_contact_phone
 * @property string|null $emergency_contact_relation
 * @property string|null $allergies
 * @property string|null $medicare_number
 * @property \Cake\I18n\DateTime|null $created
 * @property \Cake\I18n\DateTime|null $modified
 *
 * @property \App\Model\Entity\Login[] $login
 */
class Participant extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'first_name'                  => true,
        'middle_name'                 => true,
        'last_name'                   => true,
        'preferred_name'              => true,
        'email'                       => true,
        'phone'                       => true,
        'emergency_contact_name'      => true,
        'emergency_contact_phone'     => true,
        'emergency_contact_relation'  => true,
        'allergies'                   => true,
        'medicare_number'             => true,
        'created'                     => true,
        'modified'                    => true,
        'login'                       => true,
        'participant_addresses'       => true,
        'contacts'                    => true,
        'dob'                         => true,
        'gender'                      => true,
        'review_date'                 => true,
        'note'                        => true,
    ];
}
