<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;
use Authentication\PasswordHasher\DefaultPasswordHasher;

class Register extends Entity
{
    protected array $_accessible = [
        'first_name'   => true,
        'last_name'    => true,
        'email'        => true,
        'password'     => true,
        'terms_agreed' => true,
        'created'      => true,
        'modified'     => true,
        'date_of_birth'     => true,
        'mobile_phone'     => true,
    ];

    protected array $_hidden = ['password'];

    protected function _setPassword(?string $password): ?string
    {
        if ($password === null || $password === '') {
            return $password;
        }
        return (new DefaultPasswordHasher())->hash($password);
    }
}
