<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

class CalendarEventsTable extends Table
{
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('calendar_events');
        $this->setPrimaryKey('id');
        $this->setDisplayField('title');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Login', [
            'foreignKey' => 'user_id',
            'joinType'   => 'LEFT',
        ]);

        $this->belongsTo('Participants', [
            'foreignKey' => 'participant_id',
            'joinType'   => 'LEFT',
        ]);

        $this->belongsTo('Services', [
            'foreignKey' => 'service_id',
            'joinType'   => 'LEFT',
        ]);
    }

    public function validationDefault(Validator $v): Validator
    {
        return $v
            ->requirePresence('title', 'create')
            ->notEmptyString('title', 'Title is required')
            ->requirePresence('start', 'create')
            ->notEmptyDateTime('start', 'Start is required')
            ->allowEmptyDateTime('end')
            ->allowEmptyString('description')
            ->scalar('description')
            ->scalar('location')->maxLength('location', 255)->allowEmptyString('location')
            ->scalar('bg_color')->maxLength('bg_color', 20)->allowEmptyString('bg_color')
            ->scalar('text_color')->maxLength('text_color', 20)->allowEmptyString('text_color')
            ->scalar('contact')->maxLength('contact', 255)->allowEmptyString('contact')
            ->integer('user_id')->allowEmptyString('user_id')
            ->integer('participant_id')->allowEmptyString('participant_id')
            ->integer('service_id')->allowEmptyString('service_id')
            ->inList('status', ['confirmed','pending','cancelled'], 'Invalid status')
            ->inList('appointment_type', ['first','standard'], 'Invalid appointment type')
            ->allowEmptyString('appointment_type')
            ->scalar('service_type')->maxLength('service_type', 100)->allowEmptyString('service_type')
            ->scalar('service_name')->maxLength('service_name', 255)->allowEmptyString('service_name');
    }

    public function buildRules(RulesChecker $rules): RulesChecker
    {
        $rules->add($rules->existsIn(['user_id'], 'Login'), ['errorField' => 'user_id']);
        $rules->add($rules->existsIn(['participant_id'], 'Participants'), ['errorField' => 'participant_id']);
        $rules->add($rules->existsIn(['service_id'], 'Services'), ['errorField' => 'service_id']);
        return $rules;
    }
}
