<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * ClinicUsers Model
 *
 * @property \App\Model\Table\ClinicsTable&\Cake\ORM\Association\BelongsTo $Clinics
 * @property \App\Model\Table\LoginTable&\Cake\ORM\Association\BelongsTo $Logins
 *
 * @method \App\Model\Entity\ClinicUser newEmptyEntity()
 * @method \App\Model\Entity\ClinicUser newEntity(array $data, array $options = [])
 * @method array<\App\Model\Entity\ClinicUser> newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\ClinicUser get(mixed $primaryKey, array|string $finder = 'all', \Psr\SimpleCache\CacheInterface|string|null $cache = null, \Closure|string|null $cacheKey = null, mixed ...$args)
 * @method \App\Model\Entity\ClinicUser findOrCreate($search, ?callable $callback = null, array $options = [])
 * @method \App\Model\Entity\ClinicUser patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method array<\App\Model\Entity\ClinicUser> patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\ClinicUser|false save(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method \App\Model\Entity\ClinicUser saveOrFail(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method iterable<\App\Model\Entity\ClinicUser>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\ClinicUser>|false saveMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\ClinicUser>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\ClinicUser> saveManyOrFail(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\ClinicUser>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\ClinicUser>|false deleteMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\ClinicUser>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\ClinicUser> deleteManyOrFail(iterable $entities, array $options = [])
 *
 * @mixin \Cake\ORM\Behavior\TimestampBehavior
 */
class ClinicUsersTable extends Table
{
    /**
     * Initialize method
     *
     * @param array<string, mixed> $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('clinic_users');
        $this->setDisplayField('role');
        $this->setPrimaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Clinics', [
            'foreignKey' => 'clinic_id',
            'joinType' => 'INNER',
        ]);
        $this->belongsTo('Logins', [
            'foreignKey' => 'login_id',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->integer('clinic_id')
            ->notEmptyString('clinic_id');

        $validator
            ->nonNegativeInteger('login_id')
            ->notEmptyString('login_id');

        $validator
            ->scalar('role')
            ->requirePresence('role', 'create')
            ->notEmptyString('role');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules): RulesChecker
    {
        $rules->add($rules->isUnique(['clinic_id', 'login_id']), ['errorField' => 'clinic_id']);
        $rules->add($rules->existsIn(['clinic_id'], 'Clinics'), ['errorField' => 'clinic_id']);
        $rules->add($rules->existsIn(['login_id'], 'Logins'), ['errorField' => 'login_id']);

        return $rules;
    }
}
