<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class FeaturesTable extends Table
{
    public function initialize(array $config): void
    {
        parent::initialize($config);
        $this->setTable('features');
        $this->setPrimaryKey('id');
        $this->hasMany('RoleFeatureSettings', [
            'foreignKey' => 'feature_id',
            'dependent'  => true,
        ]);
    }

    public function findMap()
    {
        return $this->find()->all()->combine('key', function($row){ return $row; })->toArray();
    }
}
