<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;
use Cake\Validation\Validator;

class ParticipantFilesTable extends Table
{
    public function initialize(array $config): void
    {
        parent::initialize($config);
        $this->setTable('participant_files');
        $this->setPrimaryKey('id');
        $this->addBehavior('Timestamp');

        $this->belongsTo('Participants', ['foreignKey' => 'participant_id']);
        $this->belongsTo('Login', [
            'className'  => 'Login',
            'foreignKey' => 'uploader_id',
            'propertyName' => 'uploader',
        ]);
    }

    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->integer('participant_id')->requirePresence('participant_id')->notEmptyString('participant_id')
            ->scalar('original_name')->maxLength('original_name', 255)->requirePresence('original_name')->notEmptyString('original_name')
            ->scalar('filename')->maxLength('filename', 255)->requirePresence('filename')->notEmptyString('filename');

        return $validator;
    }
}
