<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;
use Cake\Validation\Validator;

class WaitlistTable extends Table
{
    public function initialize(array $config): void
    {
        parent::initialize($config);
        $this->setTable('waitlist');
        $this->addBehavior('Timestamp');

        $this->belongsTo('Participants', ['foreignKey' => 'participant_id']);
        $this->belongsTo('Login', ['className' => 'Login', 'foreignKey' => 'clinician_id']);
    }

    public function validationDefault(Validator $v): Validator
    {
        return $v
            ->allowEmptyString('participant_name')
            ->allowEmptyString('contact')
            ->allowEmptyString('notes')
            ->inList('status', ['waiting','notified','scheduled','cancelled'], 'Invalid status');
    }

}
