<?php
declare(strict_types=1);

namespace App\Service;

use Cake\ORM\Locator\LocatorAwareTrait;

class FeatureService
{
    use LocatorAwareTrait;

    public function visibleMapForRole(string $role): array
    {
        return $this->fetchTable('RoleFeatureSettings')->getVisibleMapForRole($role);
    }

    public function isVisible(string $featureKey, string $role): bool
    {
        $map = $this->visibleMapForRole($role);
        return (bool)($map[$featureKey] ?? false);
    }
}
