<?php
$this->assign('title', 'Calendar');
/** @var array $clinicians */

$cfg = [
    'ORG_LOCS' => $this->Url->build(['controller'=>'Calendar','action'=>'locations','_ext'=>'json']),
    'FEED'   => $this->Url->build(['controller'=>'Calendar','action'=>'events','_ext'=>'json']),
    'STORE'  => $this->Url->build(['controller'=>'Calendar','action'=>'store','_ext'=>'json']),
    'MOVE'   => rtrim($this->Url->build(['controller'=>'Calendar','action'=>'move']), '/'),
    'STATUS' => rtrim($this->Url->build(['controller'=>'Calendar','action'=>'status','_ext'=>'json']), '/'),
    'CLIN'   => $this->Url->build(['controller'=>'Calendar','action'=>'clinicians','_ext'=>'json']),
    'UPDATE' => rtrim($this->Url->build(['controller'=>'Calendar','action'=>'update']), '/'),
    'DELETE' => rtrim($this->Url->build(['controller'=>'Calendar','action'=>'delete']), '/'),
    'SRV_FEED' => $this->Url->build(['controller'=>'Services','action'=>'search','_ext'=>'json']),
    'SRV_ADD'  => $this->Url->build(['controller'=>'Services','action'=>'add','_ext'=>'json']),
    'PARTS'  => $this->Url->build(['controller'=>'Participants','action'=>'suggest','_ext'=>'json']),
    'PART_CREATE' => $this->Url->build(['controller'=>'Participants','action'=>'add','_ext'=>'json']),
    'PART_ADDR' => $this->Url->build(['controller'=>'Participants','action'=>'locations','_ext'=>'json']),
    'WL_FEED'  => $this->Url->build(['controller'=>'Waitlist','action'=>'feed','_ext'=>'json']),
    'WL_ADD'   => $this->Url->build(['controller'=>'Waitlist','action'=>'add','_ext'=>'json']),
    'WL_MARK'  => rtrim($this->Url->build(['controller'=>'Waitlist','action'=>'markScheduled']), '/'),
    'REM_SCHEDULE' => $this->Url->build(['controller'=>'Reminders','action'=>'schedule','_ext'=>'json']),
    'REM_CANCEL'   => $this->Url->build(['controller'=>'Reminders','action'=>'cancel','_ext'=>'json']),
    'REM_RESYNC'   => $this->Url->build(['controller'=>'Reminders','action'=>'resync','_ext'=>'json']),
    'REM_SEND_NOW' => $this->Url->build(['controller'=>'Reminders','action'=>'sendNow','_ext'=>'json']),
    'PART_CONTACTS' => $this->Url->build(['controller'=>'Participants','action'=>'contacts','_ext'=>'json']),
    'ORG_SRV' => $this->Url->build(['controller'=>'Onboarding','action'=>'services','_ext'=>'json']),
    'CSRF'   => $this->request->getAttribute('csrfToken'),
];
?>
<?= $this->Flash->render() ?>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.5/main.min.css">
<?= $this->Html->css('calendar', ['block'=>true]) ?>

<section class="section">
    <div class="section-body">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header" style="align-items:center;gap:12px;">
                        <h4 class="mb-0">Calendar</h4>
                        <div class="ml-auto" style="display:flex;align-items:center;gap:8px;">
                            <label for="clinician" class="mb-0">Clinician</label>
                            <select id="clinician" class="form-control" style="min-width:220px"><option value="">All</option></select>
                        </div>
                    </div>
                    <div class="card-body">
                        <div id="calendar"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<div class="modal fade" id="createEventModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog" role="document"><div class="modal-content">
            <div class="modal-header align-items-center">
                <h5 class="modal-title mr-3">New Appointment</h5>
                <div class="btn-group btn-group-sm" role="group" aria-label="Appointment sections">
                    <button type="button" id="btnTabDetails" class="btn btn-outline-primary active">Details</button>
                    <button type="button" id="btnTabNote" class="btn btn-outline-primary">Clinical note</button>
                </div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span>×</span></button>
            </div>

            <div class="modal-body">
                <form id="evtForm" novalidate>
                    <div id="evtStep1" class="wizard-step">
                        <div class="form-group">
                            <label for="evtTitle">Participant / Title</label>

                            <select class="form-control" id="evtTitle"></select>

                            <small class="form-text text-muted">
                                You can <a href="#" id="lnkCreateParticipant">create a new participant</a>
                                or <a href="#" id="lnkSelectFromWL">select from wait list</a>.
                            </small>
                        </div>

                        <!--                        <div class="form-group">-->
                        <!--                            <label for="evtServiceType">Service Type</label>-->
                        <!--                            <select class="form-control" id="evtServiceType">-->
                        <!--                                <option value="">Select a service type</option>-->
                        <!--                                <option value="assessment">Assessment</option>-->
                        <!--                                <option value="therapy">Therapy</option>-->
                        <!--                                <option value="consultation">Consultation</option>-->
                        <!--                                <option value="follow_up">Follow-up</option>-->
                        <!--                            </select>-->
                        <!--                            <small class="form-text text-muted">-->
                        <!--                                Used for reporting/colour tagging. You can extend this list later.-->
                        <!--                            </small>-->
                        <!--                        </div>-->


                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="evtDate">Date</label>
                                <input type="date" class="form-control" id="evtDate" required>
                            </div>
                            <div class="form-group col-md-3">
                                <label for="evtStart">Start</label>
                                <input type="time" class="form-control" id="evtStart" value="09:00" required>
                            </div>
                            <div class="form-group col-md-3">
                                <label for="evtEnd">End</label>
                                <input type="time" class="form-control" id="evtEnd" value="09:30">
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="evtClinician">Clinician</label>
                                <select class="form-control" id="evtClinician"><option value="">Unassigned</option></select>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="evtStatus">Status</label>
                                <select class="form-control" id="evtStatus">
                                    <option value="pending">Pending</option>
                                    <option value="confirmed">Confirmed</option>
                                    <option value="cancelled">Cancelled</option>
                                </select>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="evtLocation">Location</label>
                            <select id="evtLocation" class="form-control select2" data-placeholder="Search or pick a location…"></select>
                            <small class="form-text text-muted">Type to search. Pick <em>Other address</em> to add a new one.</small>
                        </div>

                        <div class="form-group">
                            <label for="evtContact">Contact</label>
                            <input type="text" class="form-control" id="evtContact" placeholder="Email or phone…">
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="evtReminder">Reminder</label>
                                <select id="evtReminder" class="form-control">
                                    <option value="1440">1 day before</option>
                                    <option value="0">At start time</option>
                                    <option value="15">15 minutes before</option>
                                    <option value="30">30 minutes before</option>
                                    <option value="60">1 hour before</option>
                                    <option value="120">2 hours before</option>
                                    <option value="1440">1 day before</option>
                                    <option value="off">Off (no reminder)</option>
                                </select>
                                <small class="text-muted">Will be sent to the email in “Contact”.</small>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="evtReminderTpl">Reminder template</label>
                                <select id="evtReminderTpl" class="form-control">
                                    <option value="default">Default</option>
                                    <option value="short">Short</option>
                                </select>
                            </div>
                        </div>

                        <div class="d-flex justify-content-between align-items-center">
                            <a href="#" id="lnkAddToWL">Add to wait list</a>
                        </div>
                    </div>

                    <div id="evtStep2" class="wizard-step" style="display:none;">
                        <div class="card">
                            <div class="card-header d-flex align-items-center" style="gap:8px;">
                                <strong class="mr-2 mb-0">Clinical note</strong>
                                <select id="noteTpl" class="form-control form-control-sm" style="max-width:260px;">
                                    <option value="">Select a template (optional)</option>
                                    <option value="generic">SOAP</option>
                                    <option value="brief">Brief record</option>
                                </select>
                            </div>
                            <div class="card-body">
                                <textarea class="form-control" id="noteBody" rows="10" placeholder="Start inputting the medical visit records..."></textarea>
                            </div>
                        </div>
                    </div>
                </form>
                <div class="text-danger small" id="evtError" style="display:none;"></div>
            </div>

            <div class="modal-footer">
                <button type="button" id="btnDeleteEvent" class="btn btn-outline-danger">Delete</button>
                <button type="button" id="btnUpdateEvent" class="btn btn-primary">Save</button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
            </div>
        </div></div>
</div>

<div class="modal fade" id="waitListModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-xl" role="document"><div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Wait list</h5>
                <button type="button" class="close" data-dismiss="modal"><span>×</span></button>
            </div>
            <div class="modal-body">
                <div class="form-row mb-3">
                    <div class="col-md-6">
                        <input class="form-control" id="wlSearch" placeholder="Search by name or notes…">
                    </div>
                    <div class="col-md-4">
                        <select class="form-control" id="wlClin"><option value="">All clinicians</option></select>
                    </div>
                    <div class="col-md-2 text-right">
                        <button class="btn btn-outline-secondary btn-block" id="btnWLReload" type="button">Reload</button>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover table-bordered mb-0">
                        <thead>
                        <tr>
                            <th style="width:60px;">#</th>
                            <th>Name</th>
                            <th>Clinician</th>
                            <th>Desired date</th>
                            <th>Notes</th>
                            <th style="width:120px;" class="text-right">Action</th>
                        </tr>
                        </thead>
                        <tbody id="wlTableBody">
                        <tr><td colspan="6" class="text-center text-muted py-3">Loading…</td></tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div></div>
</div>

<div class="modal fade" id="tipsModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog" role="document"><div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Quick tips</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span>×</span></button>
            </div>
            <div class="modal-body">
                <ol class="mb-0">
                    <li>Drag and drop in the blank space of the calendar to quickly create an appointment. Or click the upper right corner <em>day/week/month</em> Switch views.</li>
                    <li>Click on the reservation card to edit. Drag to change the time. Drag to another date to change the date.</li>
                    <li>Enter "Participant/Title" to search for or directly create participants. </li>
                    <li>"Location" can be selected from the organizational address or a new address can be entered.</li>
                    <li>After filling in "Contact" and "Reminder", a reminder email will be sent automatically. </li>
                </ol>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" data-dismiss="modal">Got it</button>
            </div>
        </div></div>
</div>
<div class="modal fade" id="locationModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog" role="document"><div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Location</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span>×</span></button>
            </div>

            <div class="modal-body">
                <div class="form-group">
                    <label>Type</label>
                    <select id="locType" class="form-control">
                        <option value="other" selected>Other address</option>
                        <option value="org">Organisation's location</option>
                        <option value="online">Online Consultation</option>
                        <option value="phone">Phone Consultation</option>
                    </select>
                    <small class="text-muted">Select "Other address" to manually enter the detailed address; The rest are fixed options. </small>
                </div>

                <div id="locFields">
                    <div class="form-group mb-2">
                        <label>Address line 1</label>
                        <input id="locAddr1" class="form-control" placeholder="Street address">
                    </div>
                    <div class="form-group mb-2">
                        <label>Address line 2</label>
                        <input id="locAddr2" class="form-control" placeholder="Apartment, suite, etc. (optional)">
                    </div>
                    <div class="form-row">
                        <div class="form-group col-md-4">
                            <label>City</label>
                            <input id="locCity" class="form-control">
                        </div>
                        <div class="form-group col-md-4">
                            <label>State / Region</label>
                            <input id="locRegion" class="form-control" placeholder="e.g. VIC">
                        </div>
                        <div class="form-group col-md-4">
                            <label>Postcode</label>
                            <input id="locPostcode" class="form-control" inputmode="numeric" pattern="[0-9]*">
                        </div>
                    </div>
                    <div class="form-group">
                        <label>Country</label>
                        <input id="locCountry" class="form-control" value="Australia">
                    </div>
                </div>
            </div>

            <div class="modal-footer">
                <button type="button" id="btnLocSave" class="btn btn-primary">Use this location</button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
            </div>
        </div></div>
</div>

<?php $this->start('scriptBottom'); ?>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/themes/material_blue.css">
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.full.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.5/main.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.5/locales-all.min.js"></script>
<script>window.__CAL_CFG__ = <?= json_encode($cfg, JSON_UNESCAPED_SLASHES) ?>;</script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        var cfg = window.__CAL_CFG__ || {};
        var url = cfg.ORG_LOCS;
        var sel = document.getElementById('evtLocation');
        if (!url || !sel) return;

        if (!('orgLocOptions' in window)) window.orgLocOptions = [];

        fetch(url)
            .then(function (res) { return res.json(); })
            .then(function (rows) {
                var mapped = Array.isArray(rows) ? rows.map(function (r) {
                    var label = String((r && r.label) || '').trim();
                    if (!label) return null;
                    return {
                        value: label,
                        text: r && r.primary ? (label + ' (Primary)') : label
                    };
                }).filter(Boolean) : [];

                var seen = Object.create(null);
                window.orgLocOptions = mapped.filter(function (x) {
                    if (seen[x.value]) return false;
                    seen[x.value] = 1;
                    return true;
                });

                if (typeof window.rebuildLocationOptions === 'function') {
                    window.rebuildLocationOptions();
                    return;
                }

                var keepValue = (window.jQuery && jQuery.fn && jQuery(sel).data('select2'))
                    ? String(jQuery(sel).val() || '')
                    : (sel.value || '');

                var old = sel.querySelector('optgroup[data-origin="org"]');
                if (old) old.remove();

                if (window.orgLocOptions.length) {
                    var og = document.createElement('optgroup');
                    og.label = "Organisation's location";
                    og.setAttribute('data-origin', 'org');

                    window.orgLocOptions.forEach(function (it) {
                        var o = document.createElement('option');
                        o.value = it.value;
                        o.textContent = it.text || it.value;
                        og.appendChild(o);
                    });

                    if (sel.firstElementChild && sel.firstElementChild.tagName === 'OPTION' && sel.firstElementChild.value === '') {
                        sel.insertBefore(og, sel.firstElementChild.nextSibling);
                    } else {
                        sel.insertBefore(og, sel.firstChild);
                    }
                }

                if (window.jQuery && jQuery.fn && jQuery(sel).data('select2')) {
                    jQuery(sel).val(keepValue || null).trigger('change.select2');
                } else {
                    sel.value = keepValue || '';
                }
            })
            .catch(function (err) {
                console.error('Failed to load organisation locations', err);
                window.orgLocOptions = [];
                if (typeof window.rebuildLocationOptions === 'function') {
                    window.rebuildLocationOptions();
                }
            });
    });
</script>

<script>
    (function() {
        if (!window.echarts) return;
        try {
            const orig = window.echarts.init;
            window.echarts.init = new Proxy(orig, {
                apply(target, thisArg, args) {
                    const el = args && args[0];
                    if (!el || !el.nodeType) {
                        return { setOption(){}, resize(){}, dispose(){} };
                    }
                    return Reflect.apply(target, thisArg, args);
                }
            });
        } catch (_) {}
    })();
    (function($){
        if (!$ || !$.fn.select2) return;
        $(document).on('shown.bs.modal', '#participantModal', function () {
            var $dlg = $(this), $host = $dlg.find('.modal-content');
            $dlg.find('.modal-content').css('overflow','visible');
            $dlg.find('select.select2').each(function(){
                var $sel=$(this); try{$sel.select2('destroy');}catch(e){}
                $sel.select2({ width:'100%', dropdownParent:$host, placeholder:$sel.data('placeholder')||'', allowClear:true, closeOnSelect:!$sel.prop('multiple') });
            });
        });
    })(jQuery);
    (function () {
        'use strict';
        var cfg = window.__CAL_CFG__ || {};
        var $  = window.jQuery;

        function val(id){ var el=document.getElementById(id); return el ? (el.value || '').trim() : ''; }
        function showErr(msg){
            var box = document.getElementById('evtError');
            if (!box) { alert(msg); return; }
            box.textContent = msg || 'Error';
            box.style.display = 'block';
        }
        function clearErr(){
            var box = document.getElementById('evtError');
            if (box){ box.textContent=''; box.style.display='none'; }
        }

        var lnkAdd = document.getElementById('lnkAddToWL');
        if (!lnkAdd) return;

        lnkAdd.addEventListener('click', async function(e){
            e.preventDefault();
            clearErr();

            var name        = val('evtTitle');
            var clinicianId = val('evtClinician');
            var desiredDate = val('evtDate');
            var contact     = (function(){
                var el = document.getElementById('evtContact');
                if (!el) return '';
                if ($ && $.fn && $.fn.select2 && $(el).hasClass('select2-hidden-accessible')) {
                    return String($(el).val() || '').trim();
                }
                return String(el.value || '').trim();
            })();
            var notes = val('noteBody');

            if (!cfg.WL_ADD) {
                showErr('Wait list API is not configured.');
                return;
            }
            if (!name) {
                showErr('Please enter “Participant / Title” before adding to wait list.');
                return;
            }

            var payload = {
                name: name,
                clinician_id: clinicianId ? Number(clinicianId) : null,
                desired_date: desiredDate || null,
                contact: contact || null,
                notes: notes || null
            };

            try{
                lnkAdd.classList.add('disabled');
                if ($) $(lnkAdd).addClass('disabled');

                const res = await fetch(cfg.WL_ADD, {
                    method: 'POST',
                    credentials: 'same-origin',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-Token': cfg.CSRF || ''
                    },
                    body: JSON.stringify(payload)
                });

                const json = await res.json().catch(function(){ return null; });

                if (!res.ok || !json || json.ok === false) {
                    throw new Error((json && (json.message || json.error)) || 'Add to wait list failed');
                }

                if ($) {
                    $(lnkAdd).text('Added to wait list ✓');
                    setTimeout(function(){ $(lnkAdd).text('Add to wait list'); }, 2000);
                } else {
                    lnkAdd.textContent = 'Added to wait list ✓';
                    setTimeout(function(){ lnkAdd.textContent = 'Add to wait list'; }, 2000);
                }
            } catch (err){
                showErr(err && err.message ? err.message : 'Add to wait list failed');
            } finally {
                lnkAdd.classList.remove('disabled');
                if ($) $(lnkAdd).removeClass('disabled');
            }
        });
    })();
    (function () {
        'use strict';

        const cfg = window.__CAL_CFG__ || {};
        const $ = window.jQuery;

        function displayName(x) {
            const parts = [x.first_name, x.middle_name, x.last_name].filter(Boolean).join(' ').trim();
            return (parts || x.full_name || x.name || x.preferred || x.email || '').trim();
        }

        function parseDOB(x) {
            return String(x.dob || x.date_of_birth || x.birthday || '').trim();
        }
        function calcAge(iso) {
            if (!iso) return '';
            const d = new Date(iso);
            if (isNaN(d)) return '';
            const t = new Date();
            let age = t.getFullYear() - d.getFullYear();
            const m = t.getMonth() - d.getMonth();
            if (m < 0 || (m === 0 && t.getDate() < d.getDate())) age--;
            return age >= 0 && age < 130 ? String(age) : '';
        }
        function fmtDOB(iso) {
            if (!iso) return '';
            const [y, m, dd] = iso.split('-');
            const mon = ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'][(+m||1)-1];
            if (y && m && dd) return `${dd} ${mon} ${y}`;
            if (y && m) return `${mon} ${y}`;
            return y || '';
        }
        function normGender(v) {
            const s = String(v || '').trim().toLowerCase();
            if (!s) return '';
            if (['m','male','man','boy'].includes(s)) return 'Male';
            if (['f','female','woman','girl'].includes(s)) return 'Female';
            if (['non-binary','nonbinary','nb','x','other','unknown','unspecified'].includes(s)) return 'Other';
            return s.charAt(0).toUpperCase() + s.slice(1);
        }

        (function injectModalZFix(){
            if (document.getElementById('__modal_zfix__')) return;
            const style = document.createElement('style');
            style.id='__modal_zfix__';
            style.textContent =
                '.modal-backdrop.show:nth-of-type(2){z-index:1055!important}' +
                '.modal.show:nth-of-type(2){z-index:1060!important}';
            document.head.appendChild(style);
        })();

        function ensureParticipantModal() {
            if (document.getElementById('participantModal')) return;
            const html = `
<div class="modal fade" id="participantModal" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Create participant</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span>×</span></button>
      </div>
      <div class="modal-body">
        <div class="text-danger small" id="pmError" style="display:none;"></div>
        <form id="pmForm" novalidate>
          <div class="form-row">
            <div class="form-group col-md-6">
              <label>First name</label>
              <input type="text" class="form-control" id="pmFirst" required>
            </div>
            <div class="form-group col-md-6">
              <label>Last name</label>
              <input type="text" class="form-control" id="pmLast">
            </div>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button type="button" id="btnCreateParticipant" class="btn btn-primary">Create</button>
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
      </div>
    </div>
  </div>
</div>`;
            document.body.insertAdjacentHTML('beforeend', html);

            if (window.jQuery) {
                jQuery(document).on('hidden.bs.modal', '.modal', function(){
                    if (jQuery('.modal.show').length) jQuery('body').addClass('modal-open');
                });
            }
        }

        (function hookOpenCreate(){
            const $ = window.jQuery;

            document.getElementById('lnkCreateParticipant')?.addEventListener('click', function(e){
                e.preventDefault();
                ensureParticipantModal();
                try { $('#evtTitle').select2('close'); $('#evtTitle').blur(); } catch(_) {}
                const name = String($('#evtTitle').val() || '').trim();
                const parts = name.split(/\s+/);
                document.getElementById('pmFirst')?.setAttribute('value', parts.shift() || '');
                document.getElementById('pmLast') ?.setAttribute('value', parts.join(' '));
                setTimeout(()=>$('#participantModal').modal('show'), 0);
            });

            if ($) {
                $(document).on('select2:select.__title', '#evtTitle', function(e){
                    const data = e.params && e.params.data;
                    if (data && data._isCreate) {
                        const name = String(data.id || '').trim();
                        try { $('#evtTitle').select2('close'); $('#evtTitle').blur(); } catch(_) {}
                        ensureParticipantModal();
                        const parts = name.split(/\s+/);
                        document.getElementById('pmFirst')?.setAttribute('value', parts.shift() || '');
                        document.getElementById('pmLast') ?.setAttribute('value', parts.join(' '));
                        $('#evtTitle').val(name || null).trigger('change.select2');
                        setTimeout(()=>$('#participantModal').modal('show'), 0);
                    }
                });
            }
        })();

        function initParticipantsSelect2() {
            const el = document.getElementById('evtTitle');
            if (!el || !window.jQuery) return;
            const $el = $(el);

            if ($el.data('select2')) $el.select2('destroy');

            $el.select2({
                width: '100%',
                dropdownParent: $('#createEventModal'),
                placeholder: 'Type a participant name…',
                allowClear: true,
                tags: false,
                minimumInputLength: 0,

                ajax: cfg.PARTS ? {
                    delay: 200,
                    transport: function (params, success, failure) {
                        const term = String(params.data.term || '').trim();
                        const words = term.split(/\s+/).filter(Boolean);
                        const queries = words.length > 1 ? words : [term || ''];
                        Promise.all(
                            queries.map(q => {
                                const u = new URL(cfg.PARTS, window.location.origin);
                                if (q) u.searchParams.set('q', q);
                                return fetch(u, { credentials: 'same-origin' })
                                    .then(r => r.ok ? r.json() : [])
                                    .catch(() => []);
                            })
                        ).then(pages => {
                            const seen = new Set();
                            const merged = [];
                            pages.flat().forEach(x => {
                                const key = String(x.id ?? x.email ?? x.name ?? Math.random());
                                if (seen.has(key)) return;
                                seen.add(key);
                                merged.push(x);
                            });
                            success({ results: merged });
                        }).catch(failure);
                    },
                    processResults: function (data, params) {
                        const list = Array.isArray(data.results) ? data.results : [];
                        const term = String(params.term || '').trim().toLowerCase();

                        const items = list.map(x => {
                            const name   = displayName(x);
                            const dobIso = parseDOB(x);
                            const gender = normGender(x.gender || x.sex);
                            return {
                                id: name,
                                text: name,
                                _email:  x.email || '',
                                _dob:    dobIso,
                                _age:    calcAge(dobIso),
                                _gender: gender,
                                _raw:    x
                            };
                        });

                        const hasExact = term && items.some(i => (i.text || '').toLowerCase() === term);
                        if (term && !hasExact) {
                            items.push({
                                id: term,
                                text: `＋ Create "${params.term}"`,
                                _isCreate: true
                            });
                        }

                        return { results: items };
                    }
                } : null,

                templateResult: function (di) {
                    if (!di.id) return di.text;

                    if (di._isCreate) {
                        const n = document.createElement('div');
                        n.className = 'opt-add';
                        n.innerHTML = `<div class="plus">＋</div>
            <div>
              <div class="add-main">${di.text.replace(/^＋\s*Create\s*/,'Create ')}</div>
              <div class="add-sub">Create a new participant</div>
            </div>`;
                        return n;
                    }

                    const avatar = (di.text?.trim()?.[0] || '#').toUpperCase();
                    const email  = di._email || '';
                    const dobStr = di._dob ? fmtDOB(di._dob) : '';
                    const ageStr = di._age ? `${di._age}y` : '';
                    const genStr = di._gender || '';
                    const chips = [];
                    if (dobStr || ageStr) chips.push(`${dobStr}${dobStr && ageStr ? ' • ' : ''}${ageStr}`);
                    if (genStr) chips.push(genStr);

                    const wrap = document.createElement('div');
                    wrap.className = 'opt-person';
                    wrap.innerHTML = `
          <div class="opt-avatar">${avatar}</div>
          <div class="opt-text">
            <div class="opt-name">${di.text || ''}</div>
            ${email ? `<div class="opt-sub">${email}</div>` : ''}
            ${chips.length ? `<div class="opt-meta">${chips.map(c => `<span class="chip">${c}</span>`).join(' ')}</div>` : ''}
          </div>`;
                    return wrap;
                },

                templateSelection: function (di) {
                    if (!di || !di.id) return di?.text || '';
                    if (di._isCreate) return String(di.id || '').trim();
                    return di.text || '';
                },

                dropdownCssClass: 'dropdown-title',
                selectionCssClass: 'title-select'
            });

            $el.off('select2:select.__title').on('select2:select.__title', function (e) {
                const data = e.params && e.params.data;
                if (data && data._isCreate) {
                    const name = String(data.id || '').trim();
                    try { $el.select2('close'); } catch (_) {}
                    try { $el.blur(); } catch (_) {}

                    if (name) {
                        const parts = name.split(/\s+/);
                        const first = parts.shift() || '';
                        const last  = parts.join(' ');
                        const pf = document.getElementById('pmFirst');
                        const pl = document.getElementById('pmLast');
                        if (pf) pf.value = first;
                        if (pl) pl.value = last;
                    }

                    setTimeout(() => {
                        $('#participantModal').modal('show');
                    }, 0);

                    $el.val(name || null).trigger('change.select2');
                }
            });
        }

        if ($) {
            $(document).on('shown.bs.modal', '#createEventModal', function () {
                initParticipantsSelect2();
            });
        } else {
            document.addEventListener('DOMContentLoaded', initParticipantsSelect2);
        }
    })();
</script>
<script>
    (function () {
        function injectHelpButton() {
            var cal = document.getElementById('calendar');
            if (!cal) return;

            var rightChunk = cal.querySelector('.fc-header-toolbar .fc-toolbar-chunk:last-child');
            if (!rightChunk) return;

            if (rightChunk.querySelector('.fc-help-button')) return; // 已插过

            var btn = document.createElement('button');
            btn.type = 'button';
            btn.className = 'fc-button fc-button-primary fc-help-button';
            btn.style.marginRight = '6px';
            btn.title = 'How to use';
            btn.textContent = 'Help';

            rightChunk.insertBefore(btn, rightChunk.firstChild);

            btn.addEventListener('click', function () {
                if (window.jQuery && jQuery.fn && jQuery.fn.modal) {
                    jQuery('#tipsModal').modal('show');
                } else {
                    alert(
                        'Quick tips:\\n'
                        + '1) Drag and drop in the blank space of the calendar to create an appointment; Switch views between day/week/month. \\n'
                        + '2) Click to make an appointment for editing; Drag to change the time/date. \\n'
                        + '3) The title can search for or create new participants; The organizational address can be selected. \\n'
                        + '4) Fill in "Contact" and "Reminder" to send reminder emails. '
                    );
                }
            });
        }

        injectHelpButton();

        var calRoot = document.getElementById('calendar');
        if (calRoot && 'MutationObserver' in window) {
            var mo = new MutationObserver(function () {
                injectHelpButton();
            });
            mo.observe(calRoot, { childList: true, subtree: true });
        }

        setTimeout(injectHelpButton, 300);
        setTimeout(injectHelpButton, 800);
    })();
</script>

<script>
    (function(){
        var sel = document.getElementById('locType');
        var box = document.getElementById('locFields');
        function toggle(){
            if (!sel || !box) return;
            box.style.display = (sel.value === 'other') ? '' : 'none';
        }
        if (sel){ sel.addEventListener('change', toggle); toggle(); }
    })();
</script>
<?= $this->Html->script('calendar') ?>
<?php $this->end(); ?>
