<style>
    body { background: #f6f7fb; }
    .main-content .section { padding-top: 10px; }

    .g-3 { margin-left: 0; margin-right: 0; }
    .g-3 > [class^="col"], .g-3 > [class*=" col"] { padding-left: .75rem; padding-right: .75rem; }
    .g-4 > [class^="col"], .g-4 > [class*=" col"] { padding-left: 1rem; padding-right: 1rem; }

    .card { border-radius: 14px; box-shadow: 0 8px 20px rgba(0,0,0,.04); }
    .card.h-100 { display: flex; flex-direction: column; }
    .card .card-body { flex: 1 1 auto; }

    .card-bg { padding-bottom: .5rem; }

    #myChart { min-height: 320px; }

    .l-bg-orange .card-body { padding-top: 1.25rem; padding-bottom: 1.25rem; }

    @media (max-width: 991.98px){
        .list-inline-item { display: inline-block; margin-bottom: .5rem; }
    }

</style>
<!DOCTYPE html>
<html lang="en">
<body>
	<div class="loader"></div>
	<div id="app">
        <section class="section">
            <div class="container-fluid px-3 px-lg-4">

                <div class="row g-3 g-lg-4 mb-3">
                    <div class="col-xl-3 col-lg-6 col-md-6 mb-3 mb-xl-0">
                        <div class="card h-100">
                            <div class="card-bg">
                                <div class="p-3 d-flex justify-content-between align-items-start">
                                    <div class="col">
                                        <h6 class="mb-1">Appointment</h6>
                                        <span class="font-weight-bold mb-0 font-20">
                                            <?= number_format((int)($bookingTotal ?? 0)) ?>
                                        </span>
                                    </div>
                                    <i class="fas fa-address-card card-icon col-orange font-30 p-r-0"></i>
                                </div>
                                <canvas id="cardChart1" height="80"></canvas>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-3 col-lg-6 col-md-6 mb-3 mb-xl-0">
                        <div class="card h-100">
                            <div class="card-bg">
                                <div class="p-3 d-flex justify-content-between align-items-start">
                                    <div class="col px-0">
                                        <h6 class="mb-1">Participants</h6>
                                        <span class="font-weight-bold mb-0 font-20">
                                            <?= number_format((int)($totalCustomers ?? 0)) ?>
                                        </span>
                                    </div>
                                    <i class="fas fa-diagnoses card-icon col-green font-30 p-r-0"></i>
                                </div>
                                <canvas id="cardChart2" height="80"></canvas>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-3 col-lg-6 col-md-6 mb-3 mb-xl-0">
                        <div class="card h-100">
                            <div class="card-bg">
                                <div class="p-3 d-flex justify-content-between align-items-start">
                                    <div class="col px-0">
                                        <h6 class="mb-1">Growth</h6>
                                        <span class="font-weight-bold mb-0 font-20">+22.58%</span>
                                    </div>
                                    <i class="fas fa-chart-bar card-icon col-indigo font-30 p-r-0"></i>
                                </div>
                                <canvas id="cardChart3" height="80"></canvas>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-3 col-lg-6 col-md-6 mb-0">
                        <div class="card h-100">
                            <div class="card-bg">
                                <div class="p-3 d-flex justify-content-between align-items-start">
                                    <div class="col px-0">
                                        <h6 class="mb-1">Revenue</h6>
                                        <span class="font-weight-bold mb-0 font-20">$2,687</span>
                                    </div>
                                    <i class="fas fa-hand-holding-usd card-icon col-cyan font-30 p-r-0"></i>
                                </div>
                                <canvas id="cardChart4" height="80"></canvas>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row g-3 g-lg-4 mb-3 align-items-stretch">
                    <div class="col-xl-8 col-lg-12">
                        <div class="card h-100">
                            <div class="card-header">
                                <h4 class="mb-0">Revenue Chart</h4>
                            </div>
                            <div class="card-body">
                                <ul class="list-inline text-center mb-3">
                                    <li class="list-inline-item p-r-30">
                                        <i data-feather="arrow-up-circle" class="col-green"></i>
                                        <h5 class="m-b-0">$675</h5>
                                        <p class="text-muted font-14 m-b-0">Weekly Earnings</p>
                                    </li>
                                    <li class="list-inline-item p-r-30">
                                        <i data-feather="arrow-down-circle" class="col-orange"></i>
                                        <h5 class="m-b-0">$1,587</h5>
                                        <p class="text-muted font-14 m-b-0">Monthly Earnings</p>
                                    </li>
                                    <li class="list-inline-item p-r-30">
                                        <i data-feather="arrow-up-circle" class="col-green"></i>
                                        <h5 class="mb-0 m-b-0">$45,965</h5>
                                        <p class="text-muted font-14 m-b-0">Yearly Earnings</p>
                                    </li>
                                </ul>
                                <div id="myChart" style="min-height:320px"></div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-4 col-lg-12">
                        <div class="card l-bg-orange h-100">
                            <div class="card-body d-flex align-items-center">
                                <div class="text-white w-100">
                                    <div class="row">
                                        <div class="col-6">
                                            <h4 class="mb-1 font-26">$1,235</h4>
                                            <p class="mb-2">Avg Sales Per Month</p>
                                            <p class="mb-0"><span class="font-20">+11.25%</span> Increase</p>
                                        </div>
                                        <div class="col-6">
                                            <div class="sparkline-bar p-t-50"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row g-3 g-lg-4 mb-3">
                    <div class="col-lg-4">
                        <div class="card h-100">
                            <div class="card-header"><h4 class="mb-0">Revenue</h4></div>
                            <div class="card-body">
                                <h3 class="card-title">
                                    <i class="fas fa-dollar-sign col-green font-30 p-b-10"></i> 763,215
                                </h3>
                                <canvas id="myChart3" height="170"></canvas>
                                <div class="row pt-3">
                                    <div class="col-6">
                                        <p class="text-muted font-15 text-truncate m-b-1">Target</p>
                                        <h5><i class="fas fa-arrow-circle-up col-green m-r-5"></i>$15.3k</h5>
                                    </div>
                                    <div class="col-6">
                                        <p class="text-muted font-15 text-truncate m-b-1">Last Month</p>
                                        <h5><i class="fas fa-arrow-circle-up col-green m-r-5"></i>$12.5k</h5>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="card h-100">
                            <div class="card-header"><h4 class="mb-0">TODO</h4></div>
                            <div class="card-body">

                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="card h-100">
                            <div class="card-header"><h4 class="mb-0">World wide sales</h4></div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-12 mb-3">
                                        <div id="visitorMap" style="min-height:280px"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
	</div>

</body>
</html>
