<!DOCTYPE html>

<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">
  <title>Aegis - Admin Dashboard Template</title>
  <!-- General CSS Files -->
  <link rel="stylesheet" href="webroot/css/app.min.css">
  <!-- Template CSS -->
  <link rel="stylesheet" href="webroot/css/style.css">
  <link rel="stylesheet" href="webroot/css/components.css">
  <!-- Custom style CSS -->
  <link rel="stylesheet" href="webroot/css/custom.css">
  <link rel='shortcut icon' type='image/x-icon' href='webroot/img/favicon.ico' />
</head>

<body>
  <div class="loader"></div>
  <div id="app">
    <section class="section">
      <div class="container mt-5">
        <div class="row">
          <div class="col-12 col-sm-8 offset-sm-2 col-md-6 offset-md-3 col-lg-6 offset-lg-3 col-xl-4 offset-xl-4">
              <div class="card card-primary">
                  <div class="card-header"><h4>Reset Password</h4></div>
                  <div class="card-body">
                      <?= $this->Flash->render() ?>

                      <?= $this->Form->create(null, [
                          'url' => ['controller' => 'Login', 'action' => 'forgot'],
                          'autocomplete' => 'off',
                      ]) ?>

                      <?= $this->Form->control('email', [
                          'label' => 'Email',
                          'type' => 'email',
                          'required' => true,
                          'class' => 'form-control',
                      ]) ?>

                      <?= $this->Form->button('Reset Password', ['class' => 'btn btn-primary btn-block mt-3']) ?>
                      <?= $this->Form->end() ?>

                  </div>
              </div>
              <div class="mt-3 text-center">
                  <a href="<?= $this->Url->build(['controller'=>'Login','action'=>'index']) ?>">Back to Login</a>
              </div>
          </div>
        </div>
      </div>
    </section>
  </div>
  <!-- General JS Scripts -->
  <script src="webroot/js/app.min.js"></script>
  <!-- JS Libraies -->
  <!-- Page Specific JS File -->
  <!-- Template JS File -->
  <script src="webroot/js/scripts.js"></script>
  <!-- Custom JS File -->
  <script src="webroot/js/custom.js"></script>
</body>

</html>
