<?php
/** @var \App\Model\Entity\Login $specializations */

$this->Html->css('https://cdn.jsdelivr.net/npm/flatpickr@4.6.13/dist/flatpickr.min.css', ['block' => 'css']);
$this->Html->css('https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css', ['block' => 'css']);

$role = strtolower((string)($this->Identity->get('role') ?? ''));
?>
<style>
    .pw-rules{list-style:none;margin:.5rem 0 0 0;padding-left:0}
    .pw-rules li{display:flex;align-items:center}
    .pw-rules li i{margin-right:.4rem}
    .pw-rules .pw-ok{color:#28a745;}
    .pw-rules .pw-bad{color: #df0026;}
</style>

    <section class="section">
        <div class="container mt-2">
            <div class="row">
                <div class="col-12 col-sm-10 offset-sm-1 col-md-8 offset-md-2 col-lg-8 offset-lg-2 col-xl-8 offset-xl-2">
                    <div class="card card-primary">
                        <div class="card-header"><h4>Add New Admin</h4></div>

                        <div class="alert <?= $role === 'admin' ? 'alert-success' : 'alert-danger' ?> d-flex align-items-center mb-4" role="alert" style="gap:.5rem;">
                            <i class="fas <?= $role === 'admin' ? 'fa-user-shield' : 'fa-lock' ?>"></i>
                            <div>
                                Only administrators can create accounts.
                                <?php if ($role === 'admin'): ?>
                                    You are signed in as <strong>admin</strong>.
                                <?php else: ?>
                                    You are not authorized to use this page.
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="card-body">
                            <small class="form-text text-muted">The following fields are required for submission.</small>
                        </div>

                        <div class="card-body">
                            <div id="flashMessages">
                                <?= $this->Flash->render() ?>
                            </div>
                            <?= $this->Form->create(
                                null,
                                [
                                    'id' => 'adminForm',
                                    'url' => ['controller' => 'Login', 'action' => 'new'],
                                    'class' => 'needs-validation',
                                    'novalidate' => true
                                ]
                            ) ?>

                            <div class="row">
                                <div class="form-group col-6">
                                    <?= $this->Form->label('first_name', 'First Name') ?>
                                    <?= $this->Form->text('first_name', ['id'=>'first_name','class'=>'form-control','placeholder' => 'Enter first name','required'=>true,'autofocus'=>true]) ?>
                                    <div class="invalid-feedback">Please enter the first name.</div>
                                </div>

                                <div class="form-group col-6">
                                    <?= $this->Form->label('last_name', 'Last Name') ?>
                                    <?= $this->Form->text('last_name', ['id'=>'last_name','class'=>'form-control','placeholder' => 'Enter last name','required'=>true]) ?>
                                    <div class="invalid-feedback">Please enter the last name.</div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="form-group col-6">
                                    <?= $this->Form->label('email', 'Email') ?>
                                    <?= $this->Form->email('email', ['id'=>'email','class'=>'form-control','required'=>true,'placeholder' => 'Please enter your email',
                                    ]) ?>
                                    <div class="invalid-feedback">Please enter a valid email address.</div>
                                </div>

                                <div class="form-group col-6">
                                    <?= $this->Form->label('mobile_phone', 'Mobile Phone') ?>
                                    <?= $this->Form->text('mobile_phone', [
                                        'id' => 'mobile_phone',
                                        'class' => 'form-control',
                                        'required' => true,
                                        'placeholder' => 'Enter 10-digit number',
                                        'pattern' => '^\d{10}$', // exactly 10 digits
                                        'maxlength' => 10,
                                        'title' => 'Enter exactly 10 digits'
                                    ]) ?>
                                    <div class="invalid-feedback">Enter a valid phone number (e.g. +61 xxx xxx xxx).</div>
                                </div>
                            </div>

                            <div class="form-group">
                                <?= $this->Form->label('password', 'Password', ['class'=>'d-block']) ?>
                                <?= $this->Form->password('password', ['id'=>'password','class'=>'form-control','required'=>true,'pattern'=>'^(?=.*[A-Z])(?=.*\d).{8,}$']) ?>
                                <ul class="pw-rules" id="pwRules" style="margin:6px 0 0 0;padding-left:22px;">
                                    <li id="rule-length" class="pw-bad"><i class="far fa-dot-circle"></i> At least 8 characters</li>
                                    <li id="rule-upper"  class="pw-bad"><i class="far fa-dot-circle"></i> At least 1 uppercase letter</li>
                                    <li id="rule-number" class="pw-bad"><i class="far fa-dot-circle"></i> At least 1 number</li>
                                </ul>
                                <div id="pwFeedback" class="invalid-feedback">Password does not meet the requirements above.</div>
                            </div>

                            <div class="form-group">
                                <?= $this->Form->label('password_confirm', 'Password Confirmation', ['class'=>'d-block']) ?>
                                <?= $this->Form->password('password_confirm', ['id'=>'password_confirm','class'=>'form-control','required'=>true]) ?>
                                <div id="pw2Feedback" class="invalid-feedback">Passwords do not match.</div>
                            </div>

                            <div class="row pw-toggle-row" style="margin-top:-6px;margin-bottom:16px;">
                                <div class="form-group col-12">
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" class="custom-control-input" id="showPw">
                                        <label class="custom-control-label" for="showPw">
                                            <i class="far fa-eye" id="showPwIcon" style="margin-right:6px;"></i>
                                            <span id="showPwText">Show passwords</span>
                                        </label>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group">
                                <button type="submit" class="btn btn-primary btn-lg btn-block">Register</button>
                            </div>

                            <?= $this->Form->end() ?>
                        </div>

                        <div class="mb-4 text-muted text-center">
                            Already Registered? <a href="<?= $this->Url->build(['controller'=>'Login','action'=>'index']) ?>">Login</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php $this->start('scriptBottom'); ?>
    <script src="https://cdn.jsdelivr.net/npm/flatpickr@4.6.13/dist/flatpickr.min.js"></script>
    <script>
        (function(){
            const pwd  = document.getElementById('password');
            const pwd2 = document.getElementById('password_confirm');

            const rules = {
                len:    document.getElementById('rule-length'),
                upper:  document.getElementById('rule-upper'),
                number: document.getElementById('rule-number')
            };
            const pwFeedback  = document.getElementById('pwFeedback');
            const pw2Feedback = document.getElementById('pw2Feedback');

            function toggleRule(liEl, ok){
                if (!liEl) return;
                const icon = liEl.querySelector('i');
                liEl.classList.toggle('pw-ok',  ok);
                liEl.classList.toggle('pw-bad', !ok);
                if(icon){
                    icon.classList.toggle('fa-check-circle', ok);
                    icon.classList.toggle('fa-dot-circle', !ok);
                }
            }

            function updatePwHints(){
                const v = pwd.value || '';
                toggleRule(rules.len, v.length >= 8);
                toggleRule(rules.upper, /[A-Z]/.test(v));
                toggleRule(rules.number, /\d/.test(v));
                if(!(/[A-Z]/.test(v) && /\d/.test(v) && v.length>=8)){
                    pwd.setCustomValidity('invalid');
                    pwFeedback.textContent = 'Password must have at least 8 characters, 1 uppercase letter, and 1 number.';
                }else{
                    pwd.setCustomValidity('');
                    pwFeedback.textContent = 'Password looks good.';
                }
            }

            function checkMatch(){
                if(!pwd2.value){ pwd2.setCustomValidity(''); return; }
                const mis = pwd.value !== pwd2.value;
                pwd2.setCustomValidity(mis ? 'mismatch' : '');
                pw2Feedback.textContent = mis ? 'Passwords do not match.' : 'Passwords match.';
            }

            pwd.addEventListener('input', ()=>{ updatePwHints(); checkMatch(); });
            pwd2.addEventListener('input', checkMatch);

            const showPw   = document.getElementById('showPw');
            const showIcon = document.getElementById('showPwIcon');
            const showText = document.getElementById('showPwText');
            showPw.addEventListener('change', function(){
                const show = this.checked;
                [pwd, pwd2].forEach(el => { if(el) el.type = show ? 'text' : 'password'; });
                showIcon.classList.toggle('fa-eye', !show);
                showIcon.classList.toggle('fa-eye-slash', show);
            });
        })();
    </script>
<?php $this->end(); ?>
