<?php
/** @var \App\Model\Entity\Participant $participant */
/** @var array $clinicians */
/** @var array $relationOptions */
$this->assign('title', 'Register New Participant');
echo $this->Html->css('participants_form');
?>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css"/>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/intl-tel-input@18.5.3/build/css/intlTelInput.css"/>

<section class="section">
    <div class="section-body">
        <div class="row">
            <div class="col-12 col-xl-10 offset-xl-1">

                <?= $this->Form->create($participant, ['novalidate' => true, 'class' => 'needs-validation form-2col']) ?>

                <div class="grid-2col">

                    <div class="block">
                        <div class="block-hd">PARTICIPANT DETAILS</div>
                        <div class="block-bd">
                            <div class="form-row">
                                <div class="col-md-4">
                                    <?= $this->Form->control('first_name', [
                                        'label' => ['text' => 'Given Name', 'class' => 'req-star'],
                                        'class' => 'form-control',
                                        'required' => true,
                                        'templates' => ['inputContainer' => '<div class="form-group">{{content}}<div class="invalid-feedback">Given name is required.</div></div>']
                                    ]) ?>
                                </div>
                                <div class="col-md-4">
                                    <?= $this->Form->control('middle_name', [
                                        'label' => 'Middle Name', 'class' => 'form-control'
                                    ]) ?>
                                </div>
                                <div class="col-md-4">
                                    <?= $this->Form->control('last_name', [
                                        'label' => ['text' => 'Surname', 'class' => 'req-star'],
                                        'class' => 'form-control',
                                        'required' => true,
                                        'templates' => ['inputContainer' => '<div class="form-group">{{content}}<div class="invalid-feedback">Surname is required.</div></div>']
                                    ]) ?>
                                </div>
                            </div>

                            <div class="form-row">
                                <div class="col-md-6">
                                    <?= $this->Form->control('preferred_name', [
                                        'label' => 'Preferred Name', 'class' => 'form-control'
                                    ]) ?>
                                </div>
                            </div>

                            <div class="form-row">
                                <div class="col-md-5">
                                    <?= $this->Form->control('dob', [
                                        'label' => 'Date of Birth',
                                        'type'  => 'date',
                                        'class' => 'form-control',
                                        'max'   => date('Y-m-d'),
                                        'placeholder' => 'DD-MM-YYYY',
                                    ]) ?>
                                </div>

                                <div class="col-md-5">
                                    <?php
                                    $genderOptions = [
                                        ''                 => 'Prefer not to say',
                                        'woman'            => 'Woman',
                                        'man'              => 'Man',
                                        'non-binary'       => 'Non-binary',
                                        'transgender'      => 'Transgender',
                                        'intersex'         => 'Intersex',
                                        'self_described'   => 'Other (self-described)',
                                    ];
                                    ?>
                                    <label class="d-block">Gender</label>
                                    <?= $this->Form->select('gender_select', $genderOptions, [
                                        'empty' => false,
                                        'class' => 'form-control',
                                        'value' => $participant->gender && !isset($genderOptions[$participant->gender]) ? 'self_described' : ($participant->gender ?? ''),
                                    ]) ?>
                                    <div class="mt-2" id="genderOtherWrap" style="<?= ($participant->gender && !isset($genderOptions[$participant->gender])) ? '' : 'display:none' ?>">
                                        <?= $this->Form->text('gender_other', [
                                            'class'       => 'form-control',
                                            'placeholder' => 'Enter self-described gender',
                                            'value'       => (isset($genderOptions[$participant->gender]) ? '' : ($participant->gender ?? '')),
                                        ]) ?>
                                        <small class="text-muted">If selected “Other (self-described)”, this text will be saved.</small>
                                    </div>
                                    <?= $this->Form->hidden('gender', [
                                        'value' => (isset($genderOptions[$participant->gender]) ? ($participant->gender ?? '') : ($participant->gender ?? ''))
                                    ]) ?>
                                </div>
                            </div>

                            <div class="form-row">
                                <div class="col-md-5">
                                    <?= $this->Form->control('review_date', [
                                        'label' => 'Review Date',
                                        'type'  => 'date',
                                        'class' => 'form-control',
                                        'placeholder' => 'DD-MM-YYYY',
                                    ]) ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="block">
                        <div class="block-hd">CONTACT DETAIL</div>
                        <div class="block-bd">
                            <div class="text-muted small mb-2">
                                Add one or more contact details. Each "contact card" contains <strong>Relationship</strong>
                                Telephone number and email address; Configurable <em>Primary</em>。
                            </div>

                            <div id="contactsWrap">
                                <div class="contact-card border rounded p-2 mb-2" data-start="0">
                                    <div class="card-mini-title">Contact 1</div>

                                    <div class="row-head">
                                        <div class="head-selects">
                                            <select class="form-control js-rel" style="min-width:150px">
                                                <option value="self" selected>Self</option>
                                                <option value="parent">Parent</option>
                                                <option value="spouse">Spouse/Partner</option>
                                                <option value="sibling">Sibling</option>
                                                <option value="child">Child</option>
                                                <option value="relative">Relative</option>
                                                <option value="friend">Friend</option>
                                                <option value="guardian">Guardian</option>
                                                <option value="caregiver">Caregiver</option>
                                                <option value="other">Other</option>
                                            </select>
                                        </div>

                                        <div class="spacer"></div>

                                        <div class="row-flags">
                                            <label class="flag">
                                                <input class="form-check-input js-card-primary" type="radio" name="contacts[_primary_index]" value="0" checked>
                                                <span>Primary</span>
                                            </label>
                                            <label class="flag ml-3">
                                                <input class="form-check-input js-card-emergency" type="checkbox">
                                                <span>Emergency</span>
                                            </label>
                                        </div>

                                        <button type="button" class="btn btn-outline-danger btn-sm ml-2 js-card-del">Remove</button>
                                    </div>


                                    <input type="hidden" name="contacts[0][type]" value="phone">
                                    <input type="hidden" name="contacts[0][sort]" value="0">
                                    <input type="hidden" name="contacts[0][label]" class="js-hidden-label-phone" value="self|mobile">
                                    <input type="hidden" name="contacts[0][_delete]" value="0">
                                    <input type="hidden" class="js-phone-hidden" name="contacts[0][value]" value="">
                                    <input type="hidden" name="contacts[0][is_emergency]" class="js-he-phone" value="0">

                                    <input type="hidden" name="contacts[1][type]" value="email">
                                    <input type="hidden" name="contacts[1][sort]" value="10">
                                    <input type="hidden" name="contacts[1][label]" class="js-hidden-label-email" value="self|personal">
                                    <input type="hidden" name="contacts[1][_delete]" value="0">
                                    <input type="hidden" name="contacts[1][is_emergency]" class="js-he-email" value="0">

                                    <div class="row-body">
                                        <div class="body-block mb-3">
                                            <label class="small text-muted d-block mb-1 req-star">Phone</label>
                                            <select class="form-control js-tag-phone" style="min-width:140px" required>
                                                <option value="mobile" selected>Mobile</option>
                                                <option value="home">Home</option>
                                                <option value="work">Work</option>
                                                <option value="personal">Personal</option>
                                                <option value="other">Other</option>
                                            </select>
                                            <div class="invalid-feedback">Please choose a phone label.</div>

                                            <div class="mt-2 phone-input">
                                                <input type="tel" class="form-control js-phone" placeholder="+61 XXX XXX XXX">
                                            </div>
                                        </div>

                                        <div class="body-block">
                                            <label class="small text-muted d-block mb-1 req-star">Email</label>
                                            <select class="form-control js-tag-email" style="min-width:140px" required>
                                                <option value="personal" selected>Personal</option>
                                                <option value="work">Work</option>
                                                <option value="other">Other</option>
                                            </select>
                                            <div class="invalid-feedback">Please choose an email label.</div>

                                            <div class="mt-2">
                                                <input class="form-control js-email" type="email" name="contacts[1][value]" placeholder="name@example.com">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <button type="button" class="btn btn-soft btn-sm js-add-contact">+ Add contact</button>
                            <div class="text-muted small mt-2">Note: If the participant has a guardian or emergency contact person, please select the relationship as
                                <em>Guardian</em>/<em>Parent</em> </div>
                        </div>
                    </div>

                    <div class="block">
                        <div class="block-hd">ASSIGN CLINICIANS</div>
                        <div class="block-bd">
                            <?= $this->Form->select('login._ids', $clinicians, [
                                'multiple' => true, 'class' => 'form-control select2',
                                'data-placeholder' => 'Select one or more clinicians'
                            ]) ?>
                        </div>

                        <div class="block-hd">NOTES</div>
                        <div class="block-bd">
                            <?= $this->Form->control('note', [
                                'type'        => 'textarea',
                                'label'       => false,
                                'rows'        => 4,
                                'placeholder' => 'Add private notes about this participant…',
                                'class'       => 'form-control',
                            ]) ?>
                            <div class="text-muted small mt-1">Visible to staff only.</div>
                        </div>

                        <div class="block">
                            <div class="block-hd">ALERT</div>
                            <div class="block-bd">
                                <div class="text-muted small mb-2">
                                    Create a patient alert (shown on profile/overview header).
                                </div>

                                <?= $this->Form->control('alert._create', [
                                    'type' => 'checkbox',
                                    'label' => 'Create an alert for this participant now',
                                    'templates' => ['inputContainer' => '<div class="form-group">{{content}}</div>'],
                                ]) ?>

                                <div id="alertFields" style="display:none">
                                    <?= $this->Form->control('alert.alert_text', [
                                        'type' => 'textarea',
                                        'label' => 'Alert Text',
                                        'rows' => 2,
                                        'required' => false,
                                        'placeholder' => 'e.g., Severe allergy to penicillin',
                                        'class' => 'form-control',
                                    ]) ?>

                                    <div class="form-row align-items-end">
                                        <div class="col-md-5 col-lg-5">
                                            <label class="d-block">Alert Colour</label>
                                            <div class="alert-color d-flex align-items-center">
                                                <input type="color" id="alertColorPicker" value="#D91F1F" class="color-swatch">
                                                <?= $this->Form->text('alert.color_hex', [
                                                    'value' => '#D91F1F',
                                                    'class' => 'form-control color-hex',
                                                    'placeholder' => '#D91F1F',
                                                    'pattern' => '^#[0-9A-Fa-f]{6}$',
                                                ]) ?>
                                            </div>
                                        </div>

                                        <div class="col-md-4 col-lg-4">
                                            <?= $this->Form->control('alert.severity', [
                                                'type' => 'select',
                                                'label' => 'Severity',
                                                'options' => ['info'=>'Info','warning'=>'Warning','danger'=>'Danger','critical'=>'Critical'],
                                                'default' => 'danger',
                                                'class' => 'form-control',
                                            ]) ?>
                                        </div>

                                        <div class="col-md-3 col-lg-3 d-flex justify-content-md-end">
                                            <label class="flag mb-0" style="gap:10px;">
                                                <?= $this->Form->checkbox('alert.is_dismissible', ['default'=>1,'hiddenField'=>0]) ?>
                                                <span>Dismissible</span>
                                            </label>
                                        </div>
                                    </div>


                                    <div class="form-row">
                                        <div class="col-md-6">
                                            <?= $this->Form->control('alert.starts_at', [
                                                'type' => 'text', // 用 flatpickr
                                                'label' => 'Start (optional)',
                                                'class' => 'form-control js-dt',
                                                'placeholder' => 'YYYY-MM-DD HH:mm',
                                            ]) ?>
                                        </div>
                                        <div class="col-md-6">
                                            <?= $this->Form->control('alert.ends_at', [
                                                'type' => 'text',
                                                'label' => 'End (optional)',
                                                'class' => 'form-control js-dt',
                                                'placeholder' => 'YYYY-MM-DD HH:mm',
                                            ]) ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="block">
                        <div class="block-hd">ADDRESS</div>
                        <div class="block-bd" id="addressList">

                            <div class="addr-card" data-index="0">
                                <div class="form-row">
                                    <div class="col-md-6">
                                        <?= $this->Form->control('participant_addresses.0.address_type', [
                                            'label' => 'Address Type', 'type' => 'select',
                                            'options' => ['home'=>'Home','work'=>'Work','other'=>'Other'],
                                            'default' => 'home', 'class' => 'form-control'
                                        ]) ?>
                                    </div>
                                </div>

                                <?= $this->Form->control('participant_addresses.0.address_line1', [
                                    'label' => ['text' => 'Street Address', 'class' => 'req-star'],
                                    'class' => 'form-control',
                                    'required' => true,
                                    'templates' => ['inputContainer' => '<div class="form-group">{{content}}<div class="invalid-feedback">Street address is required.</div></div>']
                                ]) ?>
                                <div class="mt-2">
                                    <?= $this->Form->control('participant_addresses.0.address_line2', [
                                        'label' => 'Address Line 2', 'class' => 'form-control'
                                    ]) ?>
                                </div>

                                <div class="form-row mt-2">
                                    <div class="col-md-4">
                                        <?= $this->Form->control('participant_addresses.0.city', [
                                            'label' => ['text' => 'City', 'class' => 'req-star'],
                                            'class' => 'form-control',
                                            'required' => true,
                                            'templates' => ['inputContainer' => '<div class="form-group">{{content}}<div class="invalid-feedback">City is required.</div></div>']
                                        ]) ?>
                                    </div>

                                    <div class="col-md-4">
                                        <?php $auStates = ['ACT'=>'ACT','NSW'=>'NSW','NT'=>'NT','QLD'=>'QLD','SA'=>'SA','TAS'=>'TAS','VIC'=>'VIC','WA'=>'WA']; ?>
                                        <?= $this->Form->control('participant_addresses.0.region', [
                                            'label' => ['text' => 'State / Region', 'class' => 'req-star'],
                                            'type' => 'select',
                                            'options' => $auStates,
                                            'empty' => false,
                                            'required' => true,
                                            'class' => 'form-control',
                                            'templates' => ['inputContainer' => '<div class="form-group">{{content}}<div class="invalid-feedback">State / Region is required.</div></div>']
                                        ]) ?>
                                    </div>

                                    <div class="col-md-4">
                                        <?= $this->Form->control('participant_addresses.0.postcode', [
                                            'label' => ['text' => 'Postcode', 'class' => 'req-star'],
                                            'class' => 'form-control',
                                            'required' => true,
                                            'templates' => ['inputContainer' => '<div class="form-group">{{content}}<div class="invalid-feedback">Postcode is required.</div></div>']
                                        ]) ?>
                                    </div>
                                </div>

                                <div class="form-row mt-2">
                                    <div class="col-md-6">
                                        <?= $this->Form->control('participant_addresses.0.country', [
                                            'label' => 'Country', 'class' => 'form-control', 'value' => 'Australia'
                                        ]) ?>
                                    </div>
                                    <div class="col-md-7">
                                        <?php $tz = [
                                            'Australia/Melbourne'=>'Australia/Melbourne',
                                            'Australia/Sydney'=>'Australia/Sydney',
                                            'Australia/Brisbane'=>'Australia/Brisbane',
                                            'Australia/Perth'=>'Australia/Perth',
                                            'Australia/Adelaide'=>'Australia/Adelaide',
                                            'Australia/Hobart'=>'Australia/Hobart',
                                        ]; ?>
                                        <?= $this->Form->control('participant_addresses.0.time_zone', [
                                            'label' => 'Time Zone', 'type' => 'select',
                                            'options' => $tz, 'empty' => 'Select a time zone', 'class' => 'form-control'
                                        ]) ?>
                                    </div>
                                </div>

                                <button type="button" class="btn btn-link btn-remove-addr" style="display:none">Remove this address</button>
                            </div>

                            <button type="button" class="btn btn-outline-primary btn-sm mt-2" id="btnAddAddress">
                                ADD NEW ADDRESS
                            </button>
                        </div>
                    </div>
                </div>

                <div class="form-actions">
                    <button class="btn btn-primary">Save</button>
                    <a href="<?= $this->Url->build(['action' => 'index']) ?>" class="btn btn-secondary">Cancel</a>
                </div>

                <?= $this->Form->end() ?>

            </div>
        </div>
    </div>
</section>

<style>
    .btn-soft{ background:#eef2ff; color:#4f46e5; border:0; }
    .btn-soft:hover{ background:#e0e7ff; color:#4338ca; }
    .select2-container{ width:100% !important; }
    .contact-card{ padding:12px; background:#fafbff; border:1px solid #e5e7eb; border-radius:10px; }
    .contact-card .row-head{
        display:flex; align-items:center; gap:10px;
        padding-bottom:8px; margin-bottom:10px; border-bottom:1px dashed #e5e7eb;
    }
    .contact-card .spacer{ flex:1; }
    .card-mini-title{ font-weight:600; font-size:13px; color:#6b7280; margin:2px 0 8px; }
    .phone-input .iti{ width:100%; }
    .iti__country-list{ max-width:360px; }
    .block .block-bd .form-row { margin-bottom: 18px; }
    .block .block-bd .form-group { margin-bottom: 16px; }

    .block .block-bd .form-control,
    .flatpickr-input,
    .flatpickr-input ~ .form-control,
    input.hasDatepicker {
        height: 44px;
    }

    .grid-2col { grid-column-gap: 28px; grid-row-gap: 28px; }

    .flatpickr-input[readonly] {
        background-color: #fff;
        cursor: text;
    }

    .block .block-bd label { margin-bottom: 6px; }

    .block .block-bd .form-row + .form-row { margin-top: 10px; }

    .contact-card .row-head{
        display:flex;
        align-items:center;
        flex-wrap:wrap;
        gap:12px 20px;
        padding-bottom:10px;
        margin-bottom:12px;
        border-bottom:1px dashed #e5e7eb;
    }

    .contact-card .head-selects{
        flex:1 1 240px;
        min-width:240px;
    }

    .contact-card .row-flags{
        display:flex;
        align-items:center;
        gap:22px;
        flex:0 0 auto;
        white-space:nowrap;
    }

    .contact-card .flag{
        display:inline-flex;
        align-items:center;
        gap:10px;
        font-weight:500;
        color:#4b5563;
        cursor:pointer;
    }

    .contact-card .flag .form-check-input{
        position: static !important;
        float: none !important;
        margin: 0 !important;
        width: 18px;
        height: 18px;
        transform: none !important;
        vertical-align: middle;
    }

    .contact-card .js-card-del{
        margin-left:auto;
    }

    @media (max-width: 560px){
        .contact-card .row-head{ gap:10px 14px; }
        .contact-card .row-flags{ width:100%; order:2; }
        .contact-card .js-card-del{ order:3; margin-left:0; }
    }
    .alert-color { gap: 10px; }
    .color-swatch{
        width: 44px; height: 44px;
        padding: 0; border:1px solid #e5e7eb; border-radius:8px;
        background: transparent; cursor: pointer;
        display: inline-block;
    }
    .color-hex{ max-width: 160px; }

    .help-hint{ line-height: 1.35; }

    @media (max-width: 576px){
        .color-hex{ max-width: 100%; }
    }

    .req-star::after{
        content:" *";
        color:#dc2626;
        margin-left:.25rem;
        font-weight:700;
    }
</style>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>

<?php $this->start('scriptBottom'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.full.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/intl-tel-input@18.5.3/build/js/intlTelInput.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/intl-tel-input@18.5.3/build/js/utils.js"></script>

<script>
    (function () {
        if (window.jQuery && jQuery.fn && jQuery.fn.select2) {
            jQuery('.select2').select2({ width: '100%' });
        }

        const form = document.querySelector('form.needs-validation');
        if (form) {
            form.addEventListener('submit', function (e) {
                if (!form.checkValidity()) {
                    e.preventDefault();
                    e.stopPropagation();
                }
                form.classList.add('was-validated');
                document.querySelectorAll('.contact-card .js-phone')
                    .forEach(function (ip) { ip.dispatchEvent(new Event('change', { bubbles: true })); });
            }, false);
        }

        function toggleOther() {
            var sel = document.querySelector('[name="emergency_contact_relation"]');
            var grp = document.getElementById('grpRelOther');
            if (!sel || !grp) return;
            grp.style.display = (sel.value === 'other') ? '' : 'none';
            if (sel.value !== 'other') {
                var input = grp.querySelector('input'); if (input) input.value = '';
            }
        }
        var selRel = document.querySelector('[name="emergency_contact_relation"]');
        if (selRel) { selRel.addEventListener('change', toggleOther); toggleOther(); }

        var wrap = document.getElementById('contactsWrap');
        if (!wrap) return;

        function nextStart() {
            var cards = wrap.querySelectorAll('.contact-card');
            if (!cards.length) return 0;
            var last = cards[cards.length - 1];
            return parseInt(last.dataset.start, 10) + 2;
        }

        function optionsHtml(map, selectedKey) {
            var html = '';
            for (var k in map) {
                if (!map.hasOwnProperty(k)) continue;
                html += '<option value="' + k + '"' + (k === selectedKey ? ' selected' : '') + '>' + map[k] + '</option>';
            }
            return html;
        }

        var PHONE_TAGS = { mobile: 'Mobile', home: 'Home', work: 'Work', personal: 'Personal', other: 'Other' };
        var EMAIL_TAGS = { personal: 'Personal', work: 'Work', other: 'Other' };

        function cardTpl(start) {
            var idxPhone = start, idxEmail = start + 1;
            return '' +
                '<div class="contact-card border rounded p-2 mb-2" data-start="' + start + '">' +
                '<div class="card-mini-title js-card-title">Contact</div>' +
                '<div class="row-head">' +
                '<div class="head-selects">' +
                '<select class="form-control js-rel">' +
                '<option value="self">Self</option>' +
                '<option value="parent">Parent</option>' +
                '<option value="spouse">Spouse/Partner</option>' +
                '<option value="sibling">Sibling</option>' +
                '<option value="child">Child</option>' +
                '<option value="relative">Relative</option>' +
                '<option value="friend">Friend</option>' +
                '<option value="guardian">Guardian</option>' +
                '<option value="caregiver">Caregiver</option>' +
                '<option value="other">Other</option>' +
                '</select>' +
                '</div>' +
                '<div class="row-flags">' +
                '<label class="flag">' +
                '<input class="form-check-input js-card-primary" type="radio" name="contacts[_primary_index]" value="' + idxPhone + '">' +
                '<span>Primary</span>' +
                '</label>' +
                '<label class="flag">' +
                '<input class="form-check-input js-card-emergency" type="checkbox">' +
                '<span>Emergency</span>' +
                '</label>' +
                '</div>' +
                '<button type="button" class="btn btn-outline-danger btn-sm js-card-del">Remove</button>' +
                '</div>' +

                '<input type="hidden" name="contacts[' + idxPhone + '][type]" value="phone">' +
                '<input type="hidden" name="contacts[' + idxPhone + '][sort]" value="' + (idxPhone * 10) + '">' +
                '<input type="hidden" name="contacts[' + idxPhone + '][label]" class="js-hidden-label-phone" value="self|mobile">' +
                '<input type="hidden" name="contacts[' + idxPhone + '][_delete]" value="0">' +
                '<input type="hidden" class="js-phone-hidden" name="contacts[' + idxPhone + '][value]" value="">' +
                '<input type="hidden" name="contacts[' + idxPhone + '][is_emergency]" class="js-he-phone" value="0">' +

                '<input type="hidden" name="contacts[' + idxEmail + '][type]" value="email">' +
                '<input type="hidden" name="contacts[' + idxEmail + '][sort]" value="' + (idxEmail * 10) + '">' +
                '<input type="hidden" name="contacts[' + idxEmail + '][label]" class="js-hidden-label-email" value="self|personal">' +
                '<input type="hidden" name="contacts[' + idxEmail + '][_delete]" value="0">' +
                '<input type="hidden" name="contacts[' + idxEmail + '][is_emergency]" class="js-he-email" value="0">' +

                '<div class="row-body">' +
                '<div class="body-block mb-3">' +
                '<select class="form-control js-tag-phone" style="min-width:140px" required>' +
                optionsHtml(PHONE_TAGS, 'mobile') +
                '</select>' +
                '<div class="invalid-feedback">Please choose a phone label.</div>' +
                '<div class="mt-2 phone-input">' +
                '<input type="tel" class="form-control js-phone" placeholder="+61 XXX XXX XXX">' +
                '</div>' +
                '</div>' +
                '<select class="form-control js-tag-email" style="min-width:140px" required>' +
                optionsHtml(EMAIL_TAGS, 'personal') +
                '</select>' +
                '<div class="mt-2">' +
                '<input class="form-control js-email" type="email" name="contacts[' + idxEmail + '][value]" placeholder="name@example.com">' +
                '</div>' +
                '</div>' +
                '</div>' +
                '</div>';
        }

        function initPhonePicker(card) {
            var input = card.querySelector('.js-phone');
            var hidden = card.querySelector('.js-phone-hidden');
            if (!input || !hidden || !window.intlTelInput) return;

            var iti = window.intlTelInput(input, {
                initialCountry: 'au',
                separateDialCode: true,
                nationalMode: false,
                utilsScript: 'https://cdn.jsdelivr.net/npm/intl-tel-input@18.5.3/build/js/utils.js'
            });
            input._iti = iti;

            function sync() {
                var e164 = iti.getNumber();
                if (!e164) {
                    var raw = (input.value || '').trim();
                    var dc = '+' + (iti.getSelectedCountryData().dialCode || '');
                    e164 = raw ? (raw[0] === '+' ? raw : (dc + ' ' + raw)) : '';
                }
                hidden.value = e164;
                updatePrimaryValue(card);
            }
            input.addEventListener('change', sync);
            input.addEventListener('blur', sync);
        }

        function syncLabels(card) {
            var rel = (card.querySelector('.js-rel') || {}).value || 'self';
            var pTag = (card.querySelector('.js-tag-phone') || {}).value || 'mobile';
            var eTag = (card.querySelector('.js-tag-email') || {}).value || 'personal';
            var hp = card.querySelector('.js-hidden-label-phone');
            var he = card.querySelector('.js-hidden-label-email');
            if (hp) hp.value = rel + '|' + pTag;
            if (he) he.value = rel + '|' + eTag;
        }

        function updatePrimaryValue(card) {
            var start = parseInt(card.dataset.start, 10);
            var idxPhone = start;
            var idxEmail = start + 1;
            var emailVal = (card.querySelector('.js-email')?.value || '').trim();
            var phoneVal = (card.querySelector('.js-phone-hidden')?.value || '').trim();
            var radio = card.querySelector('.js-card-primary');
            if (!radio) return;
            if (emailVal) { radio.value = idxEmail; }
            else if (phoneVal) { radio.value = idxPhone; }
            else { radio.value = idxPhone; }
        }

        function renumberCards() {
            var cards = [].slice.call(wrap.querySelectorAll('.contact-card'))
                .filter(function (c) { return c.style.display !== 'none' && !c.dataset.deleted; });
            cards.forEach(function (card, i) {
                var t = card.querySelector('.card-mini-title');
                if (t) t.textContent = 'Contact ' + (i + 1);
            });
        }

        function initEmergency(card) {
            var chk = card.querySelector('.js-card-emergency');
            function syncEmergency() {
                var v = (chk && chk.checked) ? '1' : '0';
                var hep = card.querySelector('.js-he-phone');
                var hee = card.querySelector('.js-he-email');
                if (hep) hep.value = v;
                if (hee) hee.value = v;
            }
            if (chk) {
                chk.addEventListener('change', syncEmergency);
                syncEmergency();
            }
        }

        function initCard(card) {
            initPhonePicker(card);
            syncLabels(card);
            updatePrimaryValue(card);
            initEmergency(card);

            ['change', 'input', 'blur'].forEach(function (ev) {
                card.addEventListener(ev, function (e) {
                    if (e.target.matches('.js-rel, .js-tag-phone, .js-tag-email')) syncLabels(card);
                    if (e.target.matches('.js-email')) updatePrimaryValue(card);
                });
            });
        }

        var firstCard = wrap.querySelector('.contact-card');
        if (firstCard) initCard(firstCard);
        renumberCards();

        document.addEventListener('click', function (e) {
            var addBtn = e.target.closest('.js-add-contact');
            if (addBtn) {
                var start = nextStart();
                wrap.insertAdjacentHTML('beforeend', cardTpl(start));
                initCard(wrap.lastElementChild);
                renumberCards();
                return;
            }

            var delBtn = e.target.closest('.js-card-del');
            if (delBtn) {
                var card = delBtn.closest('.contact-card');
                if (!card) return;
                card.remove();
                renumberCards();
            }
        });

        const btnAdd = document.getElementById('btnAddAddress');
        const list = document.getElementById('addressList');
        if (btnAdd && list) {
            btnAdd.addEventListener('click', function () {
                const last = list.querySelector('.addr-card:last-of-type');
                const idx = last ? (parseInt(last.dataset.index, 10) + 1) : 0;
                const tpl = last.cloneNode(true);
                tpl.dataset.index = idx;

                tpl.querySelectorAll('input, select, textarea').forEach(function (el) {
                    el.value = '';
                    el.name = el.name.replace(/participant_addresses\.\d+\./, 'participant_addresses.' + idx + '.');
                });
                tpl.querySelector('.btn-remove-addr').style.display = '';
                list.insertBefore(tpl, btnAdd);

                tpl.querySelector('.btn-remove-addr').addEventListener('click', function () {
                    tpl.remove();
                }, { once: true });
            });
        }

        document.addEventListener('DOMContentLoaded', function () {
            var firstErr = document.querySelector('.error-message, .is-invalid');
            if (firstErr) {
                firstErr.scrollIntoView({ behavior: 'smooth', block: 'center' });
            }
        });
    })();

    (function () {
        var dob = document.querySelector('input[name="dob"]');
        if (dob) {
            var today = new Date().toISOString().slice(0, 10);
            dob.setAttribute('max', today);
        }

        function bindGender(root) {
            var sel = root.querySelector('select[name="gender_select"]');
            var hid = root.querySelector('input[name="gender"]');
            var wrap = root.querySelector('#genderOtherWrap');
            var txt = root.querySelector('input[name="gender_other"]');
            if (!sel || !hid) return;

            function sync() {
                if (sel.value === 'self_described') {
                    wrap && (wrap.style.display = '');
                    if (txt) hid.value = txt.value.trim();
                } else {
                    wrap && (wrap.style.display = 'none');
                    hid.value = sel.value;
                }
            }
            sel.addEventListener('change', sync);
            if (txt) txt.addEventListener('input', sync);
            sync();
        }
        bindGender(document);
    })();

    (function () {
        if (!window.flatpickr) return;
        flatpickr.localize(flatpickr.l10ns.en);

        flatpickr('input[name="dob"]', {
            dateFormat: "Y-m-d",
            altInput: true,
            altFormat: "d-m-Y",
            allowInput: true,
            maxDate: "today"
        });

        flatpickr('input[name="review_date"]', {
            dateFormat: "Y-m-d",
            altInput: true,
            altFormat: "d-m-Y",
            allowInput: true
        });
    })();

    (function () {
        'use strict';
        document.addEventListener('click', function (e) {
            var btn = e.target.closest('.js-show-note');
            if (!btn) return;
            e.preventDefault(); e.stopPropagation();

            var note = btn.getAttribute('data-note') || '';
            var bodyEl = document.getElementById('noteBody');
            if (bodyEl) {
                bodyEl.textContent = note.trim() !== '' ? note : '—';
            }
            if (window.jQuery && window.jQuery.fn && window.jQuery.fn.modal) {
                window.jQuery('#noteModal').modal('show');
            } else {
                var m = document.getElementById('noteModal');
                if (m) m.style.display = 'block';
            }
        });
    })();
    (function(){
        var chk = document.querySelector('input[name="alert[_create]"][type="checkbox"]');
        var box = document.getElementById('alertFields');
        function toggle(){ box.style.display = (chk && chk.checked) ? '' : 'none'; }
        if (chk){ chk.addEventListener('change', toggle); toggle(); }

        var colorPicker = document.getElementById('alertColorPicker');
        var colorInput  = document.querySelector('input[name="alert[color_hex]"]');
        if (colorPicker && colorInput){
            colorPicker.addEventListener('input', function(){ colorInput.value = colorPicker.value; });
            colorInput.addEventListener('input', function(){
                if (/^#[0-9A-Fa-f]{6}$/.test(colorInput.value)) colorPicker.value = colorInput.value;
            });
        }

        if (window.flatpickr){
            flatpickr('.js-dt', {
                dateFormat: 'Y-m-d H:i',
                enableTime: true,
                time_24hr: true,
                allowInput: true
            });
        }
    })();
    (function () {
        const LIMITS = {
            first_name: 40, middle_name: 40, last_name: 40, preferred_name: 40, gender_other: 30,
            note: 100,
            'alert[alert_text]': 100, 'alert[color_hex]': 7, 'alert[starts_at]': 16, 'alert[ends_at]': 16,
            'participant_addresses.*.address_line1': 100,
            'participant_addresses.*.address_line2': 100,
            'participant_addresses.*.city': 50,
            'participant_addresses.*.postcode': 10,
            'participant_addresses.*.country': 60,
            '__phone__': 20, '__email__': 100
        };

        const FIELD_LABELS = {
            first_name: 'Given Name', middle_name: 'Middle Name', last_name: 'Surname',
            preferred_name: 'Preferred Name', gender_other: 'Gender (self-described)', note: 'Notes',
            'alert[alert_text]': 'Alert Text', 'alert[color_hex]': 'Alert Colour',
            'alert[starts_at]': 'Alert Start', 'alert[ends_at]': 'Alert End',
            'participant_addresses.*.address_line1': 'Street Address',
            'participant_addresses.*.address_line2': 'Address Line 2',
            'participant_addresses.*.city': 'City',
            'participant_addresses.*.postcode': 'Postcode',
            'participant_addresses.*.country': 'Country',
            '__phone__': 'Phone', '__email__': 'Email'
        };

        const HELP_TEXT = {
            first_name: 'Given name (max 40 chars).',
            middle_name: 'Middle name (max 40 chars).',
            last_name: 'Surname (max 40 chars).',
            preferred_name: 'Preferred name (max 40 chars).',
            gender_other: 'Self-described gender (max 30 chars).',
            note: 'Internal note (max 100 chars).',
            'alert[alert_text]': 'Alert text (max 100 chars).',
            'alert[color_hex]': 'HEX color, e.g. #D91F1F (7 chars).',
            'alert[starts_at]': 'Format: YYYY-MM-DD HH:mm (max 16 chars).',
            'alert[ends_at]': 'Format: YYYY-MM-DD HH:mm (max 16 chars).'
        };
        const HELP_PATTERNS = [
            { re: /^participant_addresses\[(\d+)\]\[address_line1\]$|^participant_addresses\.\d+\.address_line1$/, text: 'Street address (max 100 chars).' },
            { re: /^participant_addresses\[(\d+)\]\[address_line2\]$|^participant_addresses\.\d+\.address_line2$/, text: 'Address line 2 (max 100 chars).' },
            { re: /^participant_addresses\[(\d+)\]\[city\]$|^participant_addresses\.\d+\.city$/,                 text: 'City (max 50 chars).' },
            { re: /^participant_addresses\[(\d+)\]\[postcode\]$|^participant_addresses\.\d+\.postcode$/,         text: 'Postcode (max 10 chars).' },
            { re: /^participant_addresses\[(\d+)\]\[country\]$|^participant_addresses\.\d+\.country$/,           text: 'Country (max 60 chars).' }
        ];
        const SPECIAL_HELP = [
            { sel: '.contact-card .js-phone', text: 'Phone number (digits only).', onInit(el){
                    el.setAttribute('inputmode','numeric');
                    el.setAttribute('pattern','[0-9 ]*');
                    if (el.dataset.__numOnlyBound!=='1'){
                        el.addEventListener('input', ()=> el.value = (el.value||'').replace(/[^\d ]+/g,''));
                        el.dataset.__numOnlyBound='1';
                    }
                }
            },
            { sel: '.contact-card .js-email', text: 'Email (max 100 chars).' },
            { sel: '.contact-card .js-tag-phone', text: 'Phone label.' },
            { sel: '.contact-card .js-tag-email', text: 'Email label.' }
        ];

        // utils
        function fieldLabel(input, fb){
            const grp = input.closest('.form-group, .body-block, .addr-card, .block-bd') || input.parentElement;
            const lab = grp && grp.querySelector('label');
            let t = lab ? (lab.textContent||'').trim() : '';
            return t || fb || input.getAttribute('placeholder') || input.name || 'This field';
        }
        function ensureError(input){
            let el = (input.parentElement||input).querySelector('.invalid-feedback.__lenmsg');
            if(!el){
                el = document.createElement('div');
                el.className = 'invalid-feedback __lenmsg';
                el.style.display = 'none';
                (input.parentElement||input).appendChild(el);
            }
            return el;
        }
        function setHelpUnder(el, text){
            let host = el.parentElement || el;
            if (host && !host.classList.contains('phone-input') && el.closest('.phone-input')) host = el.closest('.phone-input');
            let h = host.querySelector('.help-hint');
            if(!h){
                h = document.createElement('div');
                h.className = 'text-muted small help-hint mt-1';
                host.appendChild(h);
            }
            h.textContent = text;
        }
        function updateState(input){
            const max = parseInt(input.getAttribute('maxlength')||'0',10);
            if(!max || isNaN(max)) return;
            const len = (input.value||'').length;
            const msg = ensureError(input);
            const lbl = fieldLabel(input, FIELD_LABELS[input.name]||'');
            if(len>max){
                input.classList.add('is-invalid');
                msg.style.display='';
                msg.textContent = `${lbl}: over limit (${len}/${max}).`;
            }else if(len===max && document.activeElement===input){
                input.classList.add('is-invalid');
                msg.style.display='';
                msg.textContent = `${lbl}: reached max (${max}).`;
            }else{
                input.classList.remove('is-invalid');
                msg.style.display='none';
                msg.textContent='';
            }
        }

        function bindMax(input, max){
            if(!input) return;
            if(max){
                const curAttr = input.getAttribute('maxlength');
                if(!curAttr) input.setAttribute('maxlength', String(max));
                else{
                    const cur = parseInt(curAttr,10);
                    const next = isFinite(cur)? Math.min(cur,max): max;
                    if(!isFinite(cur) || next!==cur) input.setAttribute('maxlength', String(next));
                }
            }
            if(input.dataset.__lenBound!=='1'){
                ['input','keyup','change','blur'].forEach(ev=> input.addEventListener(ev, ()=>updateState(input)));
                input.dataset.__lenBound='1';
            }
            updateState(input);
        }

        function bindExact(root,name,max){
            (root||document).querySelectorAll('[name="'+name+'"]').forEach(el=> bindMax(el,max));
        }
        function bindAddr(root, field, max){
            const nodes = (root||document).querySelectorAll('input[name^="participant_addresses"], textarea[name^="participant_addresses"]');
            const reDot = new RegExp('^participant_addresses\\.\\d+\\.'+field+'$');
            const reBrk = new RegExp('^participant_addresses\\[\\d+\\]\\['+field+'\\]$');
            nodes.forEach(el=>{
                const n = el.getAttribute('name')||'';
                if(reDot.test(n)||reBrk.test(n)) bindMax(el,max);
            });
        }

        function applyHelps(root){
            root = root||document;
            root.querySelectorAll('.__lenhint').forEach(n=> n.remove());

            Object.keys(HELP_TEXT).forEach(name=>{
                root.querySelectorAll('[name="'+name+'"]').forEach(el=> setHelpUnder(el, HELP_TEXT[name]));
            });
            root.querySelectorAll('input[name^="participant_addresses"], textarea[name^="participant_addresses"]').forEach(el=>{
                const n = el.getAttribute('name')||'';
                for(const p of HELP_PATTERNS){ if(p.re.test(n)){ setHelpUnder(el, p.text); break; } }
            });
            SPECIAL_HELP.forEach(rule=>{
                root.querySelectorAll(rule.sel).forEach(el=>{
                    setHelpUnder(el, rule.text);
                    if (typeof rule.onInit==='function') rule.onInit(el);
                });
            });
        }

        function initAll(root){
            root = root||document;

            bindExact(root,'first_name',LIMITS.first_name);
            bindExact(root,'middle_name',LIMITS.middle_name);
            bindExact(root,'last_name',LIMITS.last_name);
            bindExact(root,'preferred_name',LIMITS.preferred_name);
            bindExact(root,'gender_other',LIMITS.gender_other);

            bindExact(root,'note',LIMITS.note);
            bindExact(root,'alert[alert_text]',LIMITS['alert[alert_text]']);
            bindExact(root,'alert[color_hex]',LIMITS['alert[color_hex]']);
            bindExact(root,'alert[starts_at]',LIMITS['alert[starts_at]']);
            bindExact(root,'alert[ends_at]',LIMITS['alert[ends_at]']);

            root.querySelectorAll('.contact-card .js-email').forEach(el=> bindMax(el,LIMITS.__email__));
            root.querySelectorAll('.contact-card .js-phone').forEach(el=> bindMax(el,LIMITS.__phone__));

            bindAddr(root,'address_line1',LIMITS['participant_addresses.*.address_line1']);
            bindAddr(root,'address_line2',LIMITS['participant_addresses.*.address_line2']);
            bindAddr(root,'city',LIMITS['participant_addresses.*.city']);
            bindAddr(root,'postcode',LIMITS['participant_addresses.*.postcode']);
            bindAddr(root,'country',LIMITS['participant_addresses.*.country']);

            applyHelps(root);
        }

        document.addEventListener('DOMContentLoaded', ()=> initAll(document));
        ['#contactsWrap', '#addressList'].forEach(sel=>{
            const t = document.querySelector(sel);
            if(!t) return;
            const mo = new MutationObserver(muts=>{
                muts.forEach(m=> m.addedNodes && m.addedNodes.forEach(node=>{
                    if(node && node.nodeType===1) initAll(node);
                }));
            });
            mo.observe(t,{childList:true,subtree:true});
        });
    })();
</script>

<?php $this->end(); ?>
