<?php
/** @var \App\Model\Entity\Participant $participant */
/** @var \Cake\Datasource\ResultSetInterface|\App\Model\Entity\CalendarEvent[] $events */
/** @var array<int,string> $clinNames */
$this->assign('title', 'Participant History');
use Cake\I18n\FrozenTime;
?>
<section class="section">
    <div class="section-body">
        <div class="row">
            <div class="col-12 col-lg-3 mb-3">
                <?= $this->element('participants/sidebar', ['participant' => $participant, 'active' => 'history']) ?>
            </div>

            <div class="col-12 col-lg-9">
                <div class="card">
                    <div class="card-header d-flex align-items-center">
                        <h4 class="mb-0">Appointment History</h4>
                        <div class="ml-auto">
                            <?= $this->Html->link('Back to Profile',
                                ['action' => 'edit', $participant->id],
                                ['class' => 'btn btn-light btn-sm']) ?>
                        </div>
                    </div>

                    <div class="card-body">
                        <?php if ($events->isEmpty()): ?>
                            <p class="text-muted mb-0">No appointments found for this participant.</p>
                        <?php else: ?>
                            <div class="table-responsive">
                                <table class="table table-striped table-hover">
                                    <thead>
                                    <tr>
                                        <th style="width:160px;">Start</th>
                                        <th style="width:160px;">End</th>
                                        <th>Title</th>
                                        <th style="width:140px;">Clinician</th>
                                        <th style="width:110px;">Type</th>
                                        <th style="width:110px;">Status</th>
                                        <th>Location</th>
                                        <th style="width:90px;">Note</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php foreach ($events as $e): ?>
                                        <?php
                                        $noteText = (string)($e->description
                                            ?? $e->notes
                                            ?? $e->clinical_note
                                            ?? $e->note_body
                                            ?? '');
                                        $noteB64  = base64_encode($noteText);
                                        $apptName = $e->title ?: ('Appointment #'.($e->id ?? ''));
                                        ?>
                                        <tr>
                                            <td><?= $e->start instanceof \Cake\I18n\FrozenTime ? $e->start->i18nFormat('yyyy/MM/dd HH:mm') : h((string)$e->start) ?></td>
                                            <td><?= $e->end   instanceof \Cake\I18n\FrozenTime ? $e->end->i18nFormat('yyyy/MM/dd HH:mm')   : h((string)$e->end)   ?></td>
                                            <td><?= h($e->title ?? '') ?></td>
                                            <td><?= h($clinNames[$e->user_id] ?? ($e->user_id ? ('#'.$e->user_id) : '—')) ?></td>
                                            <td><?= h($e->appointment_type ?? '-') ?></td>
                                            <td><?= h($e->status ?? '-') ?></td>
                                            <td><?= h($e->location ?? '') ?></td>
                                            <td>
                                                <?php if (trim($noteText) !== ''): ?>
                                                    <button type="button"
                                                            class="btn btn-outline-secondary btn-sm js-view-note"
                                                            data-appt="<?= h($apptName) ?>"
                                                            data-note-b64="<?= h($noteB64) ?>">
                                                        View
                                                    </button>
                                                <?php else: ?>
                                                    <span class="text-muted">—</span>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                    </tbody>

                                </table>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<div class="modal fade" id="noteModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Clinical note</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span>&times;</span></button>
            </div>
            <div class="modal-body">
        <pre id="noteModalBody" class="mb-0"
             style="white-space:pre-wrap;word-break:break-word;"></pre>
            </div>
        </div>
    </div>
</div>
<?php $this->start('scriptBottom'); ?>
<script>
    (function ($) {
        $(document).on('click', '.js-view-note', function () {
            var appt = $(this).data('appt') || 'Appointment';
            var b64  = $(this).data('note-b64') || '';
            var text = '';
            try { text = b64 ? atob(b64) : ''; } catch (e) { text = ''; }

            $('#noteModal .modal-title').text(appt + ' — Clinical note');
            $('#noteModalBody').text(text && text.trim() ? text : 'No note recorded.');
            $('#noteModal').modal('show');
        });
    })(jQuery);
</script>
<?php $this->end(); ?>
