<?php
/**
 * @var \Cake\Datasource\ResultSetInterface|\App\Model\Entity\Participant[] $participants
 * @var int    $perPage
 * @var string $q
 */
$this->assign('title', 'Participants');

$relMap = [
    'parent'    => 'Parent',
    'spouse'    => 'Spouse / Partner',
    'sibling'   => 'Sibling',
    'child'     => 'Child',
    'relative'  => 'Relative',
    'friend'    => 'Friend',
    'guardian'  => 'Guardian',
    'caregiver' => 'Caregiver',
];

$contactsApi  = $this->Url->build(['controller'=>'Participants','action'=>'contacts','_ext'=>'json']);
$addressesApi = $this->Url->build(['controller'=>'Participants','action'=>'locations','_ext'=>'json']);
?>

<section class="section">
    <div class="section-body">
        <div class="row">
            <div class="col-12">
                <div class="card">

                    <div class="card-header" style="align-items:center;gap:12px;">
                        <h4 class="mb-0">Participants</h4>

                        <form class="form-inline ml-auto" method="get" action="">
                            <div class="input-group">
                                <input type="search" name="q" class="form-control" placeholder="Search keywords" value="<?= h($q ?? '') ?>">
                                <div class="input-group-append">
                                    <button class="btn btn-outline-secondary" type="submit">Search</button>
                                </div>
                            </div>

                            <div class="ml-2">
                                <select name="limit" class="form-control" onchange="this.form.submit()">
                                    <?php foreach ([10,20,50,100,200] as $n): ?>
                                        <option value="<?= $n ?>" <?= (int)($perPage ?? 20) === $n ? 'selected':'' ?>><?= $n ?> rows</option>
                                    <?php endforeach; ?>
                                </select>
                            </div>


                            <a class="btn btn-outline-primary ml-2" href="<?= $this->Url->build(['action'=>'export']) ?>">Export CSV</a>
                            <button type="button" class="btn btn-outline-secondary ml-2" onclick="window.print()">Print</button>
                            <a class="btn btn-primary ml-2" href="<?= $this->Url->build(['action'=>'add']) ?>">Add Participant</a>
                        </form>
                    </div>

                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-striped mb-0">
                                <thead>
                                <tr>
                                    <th><?= $this->Paginator->sort('Participants.id','ID') ?></th>
                                    <th><?= $this->Paginator->sort('Participants.first_name','First Name') ?></th>
                                    <th><?= $this->Paginator->sort('Participants.middle_name','Middle Name') ?></th>
                                    <th><?= $this->Paginator->sort('Participants.last_name','Last Name') ?></th>
                                    <th><?= $this->Paginator->sort('Participants.preferred_name','Preferred Name') ?></th>

                                    <th>Addresses</th>
                                    <th>Contacts</th>

                                    <th>Emergency Contact</th>
                                    <th>Relationship</th>

                                    <th><?= $this->Paginator->sort('Participants.created','Created') ?></th>
                                    <th><?= $this->Paginator->sort('Participants.modified','Updated') ?></th>
                                    <th>Clinicians</th>
                                    <th class="text-right actions-cell">Actions</th>
                                </tr>
                                </thead>

                                <tbody>
                                <?php if (count($participants)): ?>
                                    <?php foreach ($participants as $p): ?>
                                        <?php
                                        $editUrl = $this->Url->build(['action' => 'dashboard', $p->id]);

                                        $fmtAddr = function($a) {
                                            $parts = [];
                                            if (!empty($a->address_line1)) $parts[] = (string)$a->address_line1;
                                            if (!empty($a->address_line2)) $parts[] = (string)$a->address_line2;
                                            $tail = trim(implode(' ', array_filter([(string)($a->city ?? ''),(string)($a->region ?? ''),(string)($a->postcode ?? '')])));
                                            if ($tail !== '') $parts[] = $tail;
                                            if (!empty($a->country)) $parts[] = (string)$a->country;
                                            return implode(', ', $parts);
                                        };

                                        $primaryContact = null;
                                        if (!empty($p->contacts)) {
                                            foreach ($p->contacts as $c) {
                                                if ((int)$c->is_primary === 1) { $primaryContact = $c; break; }
                                            }
                                            if (!$primaryContact) $primaryContact = $p->contacts[0] ?? null;
                                        } else {
                                            if (!empty($p->email))     $primaryContact = (object)['type'=>'email','label'=>'profile','value'=>$p->email,'is_primary'=>0];
                                            elseif (!empty($p->phone)) $primaryContact = (object)['type'=>'phone','label'=>'profile','value'=>$p->phone,'is_primary'=>0];
                                        }

                                        $homeAddress = null;
                                        if (!empty($p->participant_addresses)) {
                                            foreach ($p->participant_addresses as $a) {
                                                if (strtolower((string)$a->address_type) === 'home') { $homeAddress = $a; break; }
                                            }
                                            if (!$homeAddress) $homeAddress = $p->participant_addresses[0] ?? null;
                                        }

                                        $emgContact = null;
                                        $emgRelKey  = '';
                                        if (!empty($p->contacts)) {
                                            foreach ($p->contacts as $c) {
                                                if ((int)($c->is_emergency ?? 0) !== 1) continue;

                                                if ($emgContact === null || (
                                                        strtolower((string)$c->type) === 'phone' &&
                                                        strtolower((string)($emgContact->type ?? '')) !== 'phone'
                                                    )) {
                                                    $emgContact = $c;

                                                    $label = (string)($c->label ?? '');
                                                    $parts = explode('|', $label, 2);
                                                    $emgRelKey = strtolower(trim($parts[0] ?? ''));
                                                }
                                            }
                                        }
                                        $legacyEmgText = '';
                                        if (!$emgContact) {
                                            $name  = trim((string)($p->emergency_contact_name  ?? ''));
                                            $phone = trim((string)($p->emergency_contact_phone ?? ''));
                                            if ($name !== '' || $phone !== '') {
                                                $legacyEmgText = trim($name . ($name && $phone ? ' · ' : '') . $phone);
                                            }
                                        }
                                        $emgRelHuman = '';
                                        if ($emgRelKey !== '') {
                                            $emgRelHuman = $relMap[$emgRelKey] ?? ucfirst($emgRelKey);
                                        } elseif (!empty($p->emergency_contact_relation)) {
                                            $k = strtolower((string)$p->emergency_contact_relation);
                                            $emgRelHuman = $relMap[$k] ?? $p->emergency_contact_relation;
                                        }
                                        ?>

                                        <tr class="row-link" role="button" tabindex="0"
                                            data-href="<?= h($editUrl) ?>"
                                            aria-label="Edit participant #<?= (int)$p->id ?>">

                                            <td><?= (int)$p->id ?></td>
                                            <td><?= h($p->first_name) ?></td>
                                            <td><?= h($p->middle_name) ?></td>
                                            <td><?= h($p->last_name) ?></td>
                                            <td><?= h($p->preferred_name) ?></td>

                                            <td>
                                                <?php if ($homeAddress): ?>
                                                    <div class="one-line">
                                                        <span class="type-chip">[Home]</span>
                                                        <span><?= h($fmtAddr($homeAddress)) ?></span>
                                                    </div>
                                                <?php else: ?>
                                                    —
                                                <?php endif; ?>
                                                <button type="button"
                                                        class="btn btn-sm btn-light no-row-nav js-show-addrs ml-1"
                                                        data-id="<?= (int)$p->id ?>"
                                                        data-url="<?= h($addressesApi) ?>"
                                                        title="Show all addresses">
                                                    View
                                                </button>
                                            </td>

                                            <td>
                                                <?php if ($primaryContact): ?>
                                                    <div class="one-line <?= (int)($primaryContact->is_primary ?? 0) === 1 ? 'is-primary-row' : '' ?>">
                                                        <span class="type-chip">[<?= h(strtolower($primaryContact->type ?? '') === 'email' ? 'Email' : 'Phone') ?>]</span>
                                                        <span><?= h($primaryContact->value ?? '') ?></span>
                                                        <?php if (!empty($primaryContact->label) && strtolower((string)$primaryContact->label) !== 'login'): ?>
                                                            <span class="meta-note"> (<?= h($primaryContact->label) ?>)</span>
                                                        <?php endif; ?>
                                                        <?php if ((int)($primaryContact->is_primary ?? 0) === 1): ?>
                                                            <span class="primary-badge">PRIMARY</span>
                                                        <?php endif; ?>
                                                    </div>
                                                <?php else: ?>
                                                    —
                                                <?php endif; ?>

                                                <button type="button"
                                                        class="btn btn-sm btn-light no-row-nav js-show-contacts ml-1"
                                                        data-id="<?= (int)$p->id ?>"
                                                        data-url="<?= h($contactsApi) ?>"
                                                        title="Show all contacts">
                                                    View
                                                </button>
                                            </td>

                                            <td>
                                                <?php if ($emgContact): ?>
                                                    <div class="one-line">
                                                        <span class="type-chip">[<?= h(strtolower($emgContact->type) === 'email' ? 'Email' : 'Phone') ?>]</span>
                                                        <span><?= h($emgContact->value ?? '') ?></span>
                                                    </div>
                                                <?php elseif ($legacyEmgText !== ''): ?>
                                                    <?= h($legacyEmgText) ?>
                                                <?php else: ?>
                                                    —
                                                <?php endif; ?>
                                            </td>

                                            <td>
                                                <?php if ($emgRelHuman !== ''): ?>
                                                    <span class="rel-badge"><?= h($emgRelHuman) ?></span>
                                                <?php else: ?>
                                                    —
                                                <?php endif; ?>
                                            </td>

                                            <td><?= $p->created  ? $p->created->i18nFormat('dd-MM-yyyy HH:mm')  : '' ?></td>
                                            <td><?= $p->modified ? $p->modified->i18nFormat('dd-MM-yyyy HH:mm') : '' ?></td>

                                            <td>
                                                <?php
                                                if (!empty($p->logins)) {
                                                    $names = [];
                                                    foreach ($p->login as $u) {
                                                        $name = trim(($u->first_name ?? '') . ' ' . ($u->last_name ?? ''));
                                                        $names[] = $name !== '' ? $name : $u->email;
                                                    }
                                                    echo h(implode(', ', $names));
                                                } else {
                                                    echo '—';
                                                }
                                                ?>
                                            </td>

                                            <td class="text-right actions-cell">
                                                <?= $this->Form->create(null, [
                                                    'url' => ['action' => 'delete', $p->id],
                                                    'id'  => 'delForm-' . (int)$p->id,
                                                    'style' => 'display:none'
                                                ]) ?>
                                                <?= $this->Form->end() ?>

                                                <a href="#"
                                                   class="btn btn-sm btn-outline-danger js-confirm no-row-nav"
                                                   data-form="delForm-<?= (int)$p->id ?>"
                                                   data-title="Archive Participant"
                                                   data-message="Archive “<?= h(trim(($p->first_name ?? '') . ' ' . ($p->middle_name ?? '')  . ' ' . ($p->last_name ?? ''))) ?: 'this record' ?>”? This cannot be undone."
                                                   data-ok-text="Archive"
                                                   data-ok-class="btn-danger"
                                                   data-cancel-text="Cancel">
                                                    <i class="fas fa-trash-alt"></i> Archive
                                                </a>

                                                <a href="#"
                                                   class="btn btn-sm btn-outline-info ml-1 js-add-to-wl no-row-nav"
                                                   data-id="<?= (int)$p->id ?>"
                                                   data-name="<?= h(trim(($p->first_name ?? '') . ' ' . ($p->middle_name ?? '')  . ' ' . ($p->last_name ?? ''))) ?>"
                                                   data-email="<?= h((string)$p->email) ?>"
                                                   data-phone="<?= h((string)$p->phone) ?>">
                                                    <i class="fas fa-user-plus"></i> Add to WL
                                                </a>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr><td colspan="15" class="text-center text-muted">No data</td></tr>
                                <?php endif; ?>

                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="card-footer d-flex justify-content-between align-items-center">
                        <div class="text-muted small">
                            Page <?= $this->Paginator->counter('{{page}}') ?> of <?= $this->Paginator->counter('{{pages}}') ?>,
                            showing <?= $this->Paginator->counter('{{current}}') ?> record(s) out of <?= $this->Paginator->counter('{{count}}') ?> total
                        </div>
                        <div>
                            <?= $this->Paginator->prev('« Prev', ['class'=>'btn btn-light btn-sm'], null, ['class'=>'btn btn-light btn-sm disabled']) ?>
                            <?= $this->Paginator->numbers(['class'=>'pagination pagination-sm mb-0', 'currentTag'=>'span']) ?>
                            <?= $this->Paginator->next('Next »', ['class'=>'btn btn-light btn-sm'], null, ['class'=>'btn btn-light btn-sm disabled']) ?>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</section>

<?php
$csrf       = $this->request->getAttribute('csrfToken');
$wlAddUrl   = $this->Url->build(['controller'=>'Waitlist','action'=>'add','_ext'=>'json']);
$wlIndexUrl = $this->Url->build(['controller'=>'Waitlist','action'=>'index']);
?>

<style>
    .modal-confirm .modal-content{ border:0; border-radius:12px; box-shadow:0 10px 30px rgba(0,0,0,.12); }
    .modal-confirm .modal-header{ border:0; padding:16px 16px 0; }
    .modal-confirm .modal-body{ padding:8px 16px 4px; }
    .modal-confirm .modal-footer{ border:0; padding:0 16px 16px; }

    .mc-head{ display:flex; align-items:center; gap:12px; }
    .mc-icon{ width:44px; height:44px; border-radius:50%; background:#eef2ff; color:#4f46e5; display:flex; align-items:center; justify-content:center; font-size:20px; }
    .mc-title{ font-weight:600; font-size:16px; }
    .mc-text{ color:#6b7280; }
    .mc-text b{ color:#111827; }

    .btn-soft{ background:#eef2ff; color:#4f46e5; border:0; }
    .btn-soft:hover{ background:#e0e7ff; color:#4338ca; }

    .one-line{ display:flex; align-items:center; flex-wrap:wrap; gap:6px; }
    .type-chip{ display:inline-block; padding:2px 8px; border-radius:6px; background:#eef2ff; color:#4f46e5; font-size:.85em; font-weight:600; }
    .meta-note{ color:#6b7280; font-size:.9em; }
    .primary-badge{ display:inline-block; margin-left:6px; padding:2px 10px; border-radius:9999px; background:#4f46e5; color:#fff; font-size:.75rem; font-weight:700; letter-spacing:.02em; }
    .is-primary-row{ background:rgba(79,70,229,.05); border-radius:8px; padding:2px 6px; }
    .rel-badge{ display:inline-block; padding:4px 10px; border-radius:9999px; background:#ecfdf5; color:#065f46; font-weight:600; font-size:.85em; border:1px solid #a7f3d0; }
</style>

<div class="modal fade modal-confirm" id="confirmWLModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header pb-2">
                <div class="mc-head">
                    <div class="mc-icon"><i class="fas fa-user-plus"></i></div>
                    <div class="mc-title">Add to Waiting List</div>
                </div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="outline:none;">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body pt-2">
                <p class="mc-text mb-2">
                    Add <b id="confirmWLName">this participant</b> to the waiting list?
                </p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" id="btnConfirmWL">Confirm</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="listModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="listModalTitle">List</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="outline:none;">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <ul id="listModalBody" class="list-group small"></ul>
            </div>
        </div>
    </div>
</div>

<script>
    (function () {
        'use strict';
        var ADD_URL = '<?= h($wlAddUrl) ?>';
        var WL_URL  = '<?= h($wlIndexUrl) ?>';
        var CSRF    = '<?= h($csrf) ?>';

        function confirmAddWL(name) {
            return new Promise(function (resolve, reject) {
                var $m = $('#confirmWLModal');
                $('#confirmWLName').text(name || 'this participant');
                function clean(){ $m.off('click', '#btnConfirmWL'); $m.off('hidden.bs.modal', onHide); }
                function onHide(){ clean(); reject(); }
                $m.on('click', '#btnConfirmWL', function(){ clean(); $m.modal('hide'); resolve(); });
                $m.on('hidden.bs.modal', onHide);
                $m.modal('show');
                setTimeout(function(){ $('#btnConfirmWL').trigger('focus'); }, 50);
            });
        }

        document.addEventListener('click', function (e) {
            var btn = e.target.closest('.js-add-to-wl');
            if (!btn) return;
            e.preventDefault();

            var id    = btn.getAttribute('data-id');
            var name  = btn.getAttribute('data-name')  || '';
            var email = btn.getAttribute('data-email') || '';
            var phone = btn.getAttribute('data-phone') || '';

            confirmAddWL(name || ('#' + (id || ''))).then(function () {
                var payload = {
                    participant_id: id ? parseInt(id, 10) : '',
                    participant_name: name,
                    contact: phone || email || '',
                    clinician_id: '',
                    desired_date: '',
                    notes: ''
                };

                btn.classList.add('disabled');
                btn.setAttribute('aria-disabled', 'true');

                return fetch(ADD_URL, {
                    method: 'POST',
                    credentials: 'same-origin',
                    headers: { 'Content-Type': 'application/json', 'X-CSRF-Token': CSRF },
                    body: JSON.stringify(payload)
                })
                    .then(function (r) {
                        return r.json().catch(function(){return {};})
                            .then(function (j) { return { ok:r.ok, status:r.status, body:j }; });
                    })
                    .then(function (res) {
                        if (!res.ok || !res.body || res.body.ok === false) {
                            throw new Error((res.body && (res.body.error || res.body.message)) || ('HTTP ' + res.status));
                        }
                        window.location.href = WL_URL;
                    })
                    .catch(function (err) {
                        alert('Add failed: ' + (err && err.message ? err.message : 'Unknown'));
                    })
                    .finally(function () {
                        btn.classList.remove('disabled');
                        btn.removeAttribute('aria-disabled');
                    });
            })
                .catch(function(){ });
        });

        (function () {
            var tbody = document.querySelector('table.table tbody');
            if (!tbody) return;

            tbody.addEventListener('click', function (e) {
                if (e.target.closest('a, button, input, label, .no-row-nav, .js-confirm, .js-add-to-wl')) return;
                var tr = e.target.closest('tr.row-link');
                if (!tr) return;
                var href = tr.getAttribute('data-href');
                if (href) window.location.href = href;
            });

            tbody.addEventListener('keydown', function (e) {
                var tr = e.target.closest('tr.row-link');
                if (!tr) return;
                if (e.key === 'Enter' || e.key === ' ') {
                    e.preventDefault();
                    var href = tr.getAttribute('data-href');
                    if (href) window.location.href = href;
                }
            });
        })();

        /* ====== 通用工具 ====== */
        function qs(sel, root){ return (root||document).querySelector(sel); }
        function escapeHtml(s){ return (s||'').replace(/[&<>"']/g, m=>({ '&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#39;' }[m])); }

        function fetchJson(url){
            return fetch(url, { credentials:'same-origin' }).then(async r=>{
                const ct = (r.headers.get('content-type')||'').toLowerCase();
                if (ct.includes('application/json')) return r.json();
                const text = await r.text();
                throw new Error('Non-JSON response: ' + text.slice(0, 200));
            });
        }

        function openListModal(title, items){
            var titleEl = qs('#listModalTitle');
            var bodyEl  = qs('#listModalBody');
            if (!titleEl || !bodyEl) { alert('List modal not found'); return; }

            titleEl.textContent = title || 'List';
            bodyEl.innerHTML = '';

            if (!items || !items.length){
                var li = document.createElement('li');
                li.className = 'list-group-item text-muted';
                li.textContent = 'No data';
                bodyEl.appendChild(li);
            } else {
                items.forEach(function(row){
                    var li = document.createElement('li');
                    li.className = 'list-group-item' + (row.isPrimary ? ' is-primary' : '');
                    li.innerHTML = row.content;
                    bodyEl.appendChild(li);
                });
            }
            if (window.jQuery && window.jQuery.fn && window.jQuery.fn.modal) {
                window.jQuery('#listModal').modal('show');
            } else {
                qs('#listModal').style.display = 'block';
            }
        }

        // ==== 替换原来的 showContacts ====
        function showContacts(pid, urlOverride){
            var url = (urlOverride || '/participants/contacts.json') +
                '?participant_id=' + encodeURIComponent(pid);

            fetchJson(url)
                .then(function(rows){
                    var cleaned = (rows || []).filter(function(r){
                        return String(r.label || '').toLowerCase() !== 'login';
                    });

                    var items = cleaned.map(function(r){
                        var type  = (r.type === 'email') ? 'Email' : 'Phone';
                        var chip  = '<span class="type-chip">[' + type + ']</span>';
                        var main  = escapeHtml(r.value || '');
                        var label = r.label ? ' <span class="meta-note">(' + escapeHtml(r.label) + ')</span>' : '';
                        var badge = r.is_primary ? '<span class="primary-badge">PRIMARY</span>' : '';
                        return { isPrimary: !!r.is_primary, content: chip + ' ' + main + label + ' ' + badge };
                    });

                    openListModal('Contacts', items);
                })
                .catch(function(err){
                    console.error('contacts error:', err);
                    openListModal('Contacts', []);
                });
        }


        function showAddresses(pid, urlOverride){
            var url = (urlOverride || '<?= h($addressesApi) ?>') + '?participant_id=' + encodeURIComponent(pid);
            fetchJson(url)
                .then(function(rows){
                    var items = (rows||[]).map(function(r){
                        var chip = r.type ? ('<span class="type-chip">[' + escapeHtml(r.type) + ']</span> ') : '';
                        var text = escapeHtml(r.text || r.value || '');
                        return { isPrimary:false, content: chip + text };
                    });
                    openListModal('Addresses', items);
                })
                .catch(function(err){
                    console.error('addresses error:', err);
                    openListModal('Addresses', []);
                });
        }

        document.addEventListener('click', function(e){
            var cBtn = e.target.closest('.js-show-contacts');
            if (cBtn){
                e.preventDefault(); e.stopPropagation();
                var pid = cBtn.getAttribute('data-id');
                var url = cBtn.getAttribute('data-url');
                if (pid) showContacts(pid, url);
                return;
            }
            var aBtn = e.target.closest('.js-show-addresses, .js-show-addrs');
            if (aBtn){
                e.preventDefault(); e.stopPropagation();
                var pid = aBtn.getAttribute('data-id');
                var url = aBtn.getAttribute('data-url');
                if (pid) showAddresses(pid, url);
            }
        });
    })();
</script>
