<?php
/**
 * Participant sidebar
 *
 * @var \App\Model\Entity\Participant $participant
 * @var string|null                   $active overview|profile|personal|contact|misc|clinicians|history|files
 */
$active    = $active ?? 'overview';
$pid       = (int)($participant->id ?? 0);
$fullName  = trim(($participant->first_name ?? '') . ' ' . ($participant->last_name ?? ''));
$email     = (string)($participant->email ?? '');
?>
<div class="list-group sticky-top">

    <div class="list-group-item d-flex align-items-center">
        <div>
            <div class="font-weight-bold">
                <?= h($fullName) !== '' ? h($fullName) : 'Unnamed' ?>
            </div>
            <?php if ($email !== ''): ?>
                <div class="small text-muted"><?= h($email) ?></div>
            <?php endif; ?>
        </div>
    </div>
    <?= $this->Html->link(
        'Overview',
        ['controller' => 'Participants', 'action' => 'dashboard', $pid],
        ['class' => 'list-group-item list-group-item-action' . ($active === 'overview' ? ' active' : '')]
    ) ?>

    <?= $this->Html->link(
        'Profile',
        ['controller' => 'Participants', 'action' => 'edit', $participant->id],
        ['class' => 'list-group-item list-group-item-action' . ($active === 'profile' ? ' active' : '')]
    ) ?>

    <?= $this->Html->link(
        'History',
        ['controller' => 'Participants', 'action' => 'history', $pid],
        ['class' => 'list-group-item list-group-item-action' . ($active === 'history' ? ' active' : '')]
    ) ?>

</div>

